/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.acceptance.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductUnitVo;
import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductVo;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceGoodsEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.repository.InvoiceAcceptanceGoodsRepository;
import com.biz.crm.kms.business.invoice.acceptance.local.repository.InvoiceAcceptanceRepository;
import com.biz.crm.kms.business.invoice.acceptance.local.repository.KmsInvoiceAcceptanceGrabRepository;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceOrderGrabsThreadService;
import com.biz.crm.kms.business.invoice.acceptance.sdk.enums.AcceptanceStatus;
import com.biz.crm.kms.business.invoice.sdk.enums.DirectEnum;
import com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus;
import com.biz.crm.mn.common.base.service.RedisCrmService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class InvoiceAcceptanceOrderGrabsThreadServiceImpl
implements InvoiceAcceptanceOrderGrabsThreadService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceAcceptanceOrderGrabsThreadServiceImpl.class);
    @Autowired
    private InvoiceAcceptanceRepository invoiceAcceptanceRepository;
    @Autowired
    private InvoiceAcceptanceGoodsRepository invoiceAcceptanceGoodsRepository;
    @Autowired
    private KmsInvoiceAcceptanceGrabRepository kmsInvoiceAcceptanceGrabRepository;
    @Autowired
    private RedisCrmService redisCrmService;
    @Autowired(required=false)
    private RedisTemplate redisTemplate;

    @Override
    @Async(value="grabThread")
    @Transactional(propagation=Propagation.NOT_SUPPORTED, rollbackFor={Exception.class})
    public void saveAcceptanceOrderData(List<InvoiceAcceptanceEntity> entityList, Map<String, List<DirectVo>> directMap, Map<String, List<DirectStoreVo>> directStoreMap, Map<String, List<DirectProductVo>> directProductMap) {
        log.info("--  \u8fdb\u5165\u7ebf\u7a0b\u6c60\u5b58\u50a8\u6570\u636e  --");
        if (CollectionUtil.isEmpty(entityList)) {
            return;
        }
        List orderNumbers = entityList.stream().map(InvoiceAcceptanceEntity::getOrderNumber).collect(Collectors.toList());
        HashSet orderNumberSet = new HashSet();
        HashSet orderNumberSuccessSet = new HashSet();
        entityList.stream().filter(Objects::nonNull).filter(k -> StringUtils.isNotBlank((CharSequence)k.getOrderNumber())).forEach(entity -> {
            try {
                this.clearTransformInfoOne((InvoiceAcceptanceEntity)((Object)entity), directMap);
                String deliveryCode = this.buildOrderInfoTwo((InvoiceAcceptanceEntity)((Object)entity), directStoreMap);
                this.convertAcceptanceOrderItemThree((InvoiceAcceptanceEntity)((Object)entity), directProductMap, deliveryCode);
                this.setOrderStatusAndMsgFour((InvoiceAcceptanceEntity)((Object)entity));
                this.invoiceAcceptanceRepository.saveOrUpdate(entity);
                if (Objects.equals(AcceptanceStatus.S200.getDictCode(), entity.getOrderStatus())) {
                    orderNumberSuccessSet.add(entity.getOrderNumber());
                } else {
                    orderNumberSet.add(entity.getOrderNumber());
                }
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u9a8c\u6536\u5355\u6570\u636e\u5931\u8d25", (Throwable)e);
                entity.setOrderStatus(AcceptanceStatus.S100.getDictCode());
                entity.setTransFlag(BooleanEnum.TRUE.getCapital());
                entity.setOrderStatusMsg("\u8f6c\u6362\u65f6\u5f02\u5e38!");
                try {
                    this.invoiceAcceptanceRepository.saveOrUpdate(entity);
                    orderNumberSet.add(entity.getOrderNumber());
                }
                catch (Exception ex) {
                    log.error("", (Throwable)ex);
                }
            }
        });
        if (CollectionUtil.isEmpty(orderNumberSet) && CollectionUtils.isEmpty(orderNumberSuccessSet)) {
            return;
        }
        this.redisCrmService.hdel("KMS:ACCEPTANCE:ORDER:CONVERT:LOCK:", new Object[]{orderNumbers});
        try {
            if (!CollectionUtils.isEmpty(orderNumberSet)) {
                this.kmsInvoiceAcceptanceGrabRepository.updateTransStatusByOrderNumberList(TenantUtils.getTenantCode(), GrabTransStatus.TRANS_FAIL, new ArrayList<String>(orderNumberSet));
            }
            if (!CollectionUtils.isEmpty(orderNumberSuccessSet)) {
                this.kmsInvoiceAcceptanceGrabRepository.updateTransStatusByOrderNumberList(TenantUtils.getTenantCode(), GrabTransStatus.HAVE_TRANS, new ArrayList<String>(orderNumberSuccessSet));
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    private void clearTransformInfoOne(InvoiceAcceptanceEntity entity, Map<String, List<DirectVo>> directMap) {
        List<DirectVo> directVos;
        entity.setSoldToPartyName(null);
        entity.setSoldToPartyCode(null);
        entity.setStoreCode(null);
        entity.setStoreName(null);
        entity.setAreaName(null);
        if (StringUtils.isNotBlank((CharSequence)entity.getAcceptanceDate())) {
            try {
                entity.setAcceptanceTime(new SimpleDateFormat("yyyy-MM-dd").parse(entity.getAcceptanceDate()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (CollectionUtils.isEmpty(directVos = directMap.get(entity.getDirectCode()))) {
            entity.setOrderStatusMsg("\u4e0d\u5b58\u5728\u8be5\u7cfb\u7edf");
        } else {
            DirectVo directVo = directVos.get(0);
            entity.setBusinessFormatCode(directVo.getBusinessFormatCode());
            entity.setBusinessUnitCode(directVo.getBusinessUnitCode());
            entity.setDirectCode(directVo.getDirectCode());
            entity.setDirectName(directVo.getSupermarketName());
            entity.setKaCode(directVo.getSupermarketCode());
            entity.setKaName(directVo.getSupermarketName());
        }
    }

    private String buildOrderInfoTwo(InvoiceAcceptanceEntity entity, Map<String, List<DirectStoreVo>> directStoreMap) {
        entity.setOrderStatus(AcceptanceStatus.S100.getDictCode());
        entity.setTransFlag(BooleanEnum.TRUE.getCapital());
        if (StringUtils.isBlank((CharSequence)entity.getDirectCode())) {
            entity.setOrderStatusMsg("\u5355\u636e\u7cfb\u7edf\u7f16\u7801\u4e3a\u7a7a");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)entity.getKaStoreCode())) {
            entity.setOrderStatusMsg("\u5355\u636e\u5546\u8d85\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a");
            return null;
        }
        List<DirectStoreVo> directStoreVoList = directStoreMap.get(entity.getDirectCode() + "_" + entity.getKaStoreCode());
        DirectStoreVo directStoreVo = null;
        if (DirectEnum.GAOXIN_TJ.getDictCode().equals(entity.getDirectCode()) || DirectEnum.GAOXIN_BJ.getDictCode().equals(entity.getDirectCode())) {
            if (DirectEnum.GAOXIN_QY1.getDictCode().equals(entity.getAreaCode())) {
                entity.setAreaName(DirectEnum.GAOXIN_QY1.getDesc());
            } else if (DirectEnum.GAOXIN_QY2.getDictCode().equals(entity.getAreaCode())) {
                entity.setAreaName(DirectEnum.GAOXIN_QY2.getDesc());
            } else if (DirectEnum.GAOXIN_QY3.getDictCode().equals(entity.getAreaCode())) {
                entity.setAreaName(DirectEnum.GAOXIN_QY3.getDesc());
            } else if (DirectEnum.GAOXIN_QY4.getDictCode().equals(entity.getAreaCode())) {
                entity.setAreaName(DirectEnum.GAOXIN_QY4.getDesc());
            } else if (DirectEnum.GAOXIN_QY5.getDictCode().equals(entity.getAreaCode())) {
                entity.setAreaName(DirectEnum.GAOXIN_QY5.getDesc());
            } else {
                entity.setOrderStatusMsg("\u8be5\u5355\u636e\u4e0d\u5b58\u5728\u533a\u57df");
            }
            List directStoreVos = directStoreVoList.stream().filter(directStoreVo1 -> entity.getAreaName().equals(directStoreVo1.getRetailerRegion())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(directStoreVos)) {
                entity.setOrderStatus(AcceptanceStatus.S100.getDictCode());
                entity.setOrderStatusMsg("\u8be5\u7cfb\u7edf\u4e0b\u7684\u95e8\u5e97\u4e2d\u672a\u627e\u5230\u5339\u914d\u7684\u533a\u57df");
            }
            directStoreVo = (DirectStoreVo)directStoreVos.get(0);
            entity.setSoldToPartyCode(directStoreVo.getSoldToPartyCode());
            entity.setSoldToPartyName(directStoreVo.getSoldToPartyName());
            entity.setDeliveryPartyCode(directStoreVo.getTerminalCode());
            entity.setDeliveryPartyName(directStoreVo.getTerminalName());
            entity.setBusinessArea(directStoreVo.getBusinessArea());
            entity.setProvinceCode(directStoreVo.getProvinceCode());
            entity.setProvinceName(directStoreVo.getProvinceName());
            entity.setOrderStatus(AcceptanceStatus.S200.getDictCode());
            return directStoreVo.getRetailerTerminalCode();
        }
        if (CollectionUtil.isEmpty(directStoreVoList)) {
            entity.setOrderStatusMsg("\u672a\u67e5\u8be2\u5230\u4e0e\u4f01\u4e1a\u95e8\u5e97\u5bf9\u5e94\u5173\u7cfb");
            return null;
        }
        if (directStoreVoList.size() > 1) {
            entity.setOrderStatusMsg("\u5546\u8d85\u95e8\u5e97\u4e0e\u4f01\u4e1a\u95e8\u5e97\u5bf9\u5e94\u5173\u7cfb\u5b58\u5728[" + directStoreVoList.size() + "]\u6761");
            return null;
        }
        directStoreVo = directStoreVoList.get(0);
        if (StringUtils.isEmpty((CharSequence)entity.getKaStoreName())) {
            entity.setKaStoreName(directStoreVo.getSupermarketStoreName());
        }
        entity.setSoldToPartyCode(directStoreVo.getSoldToPartyCode());
        entity.setSoldToPartyName(directStoreVo.getSoldToPartyName());
        entity.setDeliveryPartyCode(directStoreVo.getTerminalCode());
        entity.setDeliveryPartyName(directStoreVo.getTerminalName());
        entity.setAreaName(directStoreVo.getRetailerRegion());
        entity.setBusinessArea(directStoreVo.getBusinessArea());
        entity.setProvinceCode(directStoreVo.getProvinceCode());
        entity.setProvinceName(directStoreVo.getProvinceName());
        entity.setOrderStatus(AcceptanceStatus.S200.getDictCode());
        return directStoreVo.getRetailerTerminalCode();
    }

    private void convertAcceptanceOrderItemThree(InvoiceAcceptanceEntity entity, Map<String, List<DirectProductVo>> directProductMap, String deliveryCode) {
        if (CollectionUtils.isEmpty(entity.getGoodsList())) {
            entity.setOrderStatus(AcceptanceStatus.S100.getDictCode());
            entity.setOrderStatusMsg("\u5546\u54c1\u884c\u4fe1\u606f\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        AtomicReference<BigDecimal> finalOrderAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> finalOrderAmountNot = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> finalAcceptanceAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> finalAcceptanceAmountNot = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        String createAccount = entity.getCreateAccount();
        String createName = entity.getCreateName();
        String modifyAccount = entity.getModifyAccount();
        String modifyName = entity.getModifyName();
        BigDecimal decimal = new BigDecimal(1);
        Map map = this.redisTemplate.hasKey((Object)"KMS:CACHE:PRODUCT_TAX_RATE") != false ? (Map)this.redisTemplate.opsForValue().get((Object)"KMS:CACHE:PRODUCT_TAX_RATE") : null;
        entity.getGoodsList().forEach(orderGoodsEntity -> {
            this.clearTransformItem((InvoiceAcceptanceGoodsEntity)((Object)orderGoodsEntity));
            orderGoodsEntity.setCreateAccount(createAccount);
            orderGoodsEntity.setCreateName(createName);
            orderGoodsEntity.setModifyAccount(modifyAccount);
            orderGoodsEntity.setModifyName(modifyName);
            orderGoodsEntity.setCurCompanyUnitOrderQuantity(BigDecimal.ZERO);
            DirectProductVo productVo = this.getGoodsInfo((InvoiceAcceptanceGoodsEntity)((Object)orderGoodsEntity), entity, directProductMap, deliveryCode);
            this.buildGoodsInfo((InvoiceAcceptanceGoodsEntity)((Object)orderGoodsEntity), entity, productVo);
            orderGoodsEntity = this.setAccount((InvoiceAcceptanceGoodsEntity)((Object)orderGoodsEntity), decimal, map);
            if (Objects.nonNull(orderGoodsEntity.getOrderAmount())) {
                finalOrderAmount.set(((BigDecimal)finalOrderAmount.get()).add(orderGoodsEntity.getOrderAmount()));
            }
            if (Objects.nonNull(orderGoodsEntity.getOrderAmountNot())) {
                finalOrderAmountNot.set(((BigDecimal)finalOrderAmountNot.get()).add(orderGoodsEntity.getOrderAmountNot()));
            }
            if (Objects.nonNull(orderGoodsEntity.getAcceptanceAmount())) {
                finalAcceptanceAmount.set(((BigDecimal)finalAcceptanceAmount.get()).add(orderGoodsEntity.getAcceptanceAmount()));
            }
            if (Objects.nonNull(orderGoodsEntity.getAcceptanceAmountNot())) {
                finalAcceptanceAmountNot.set(((BigDecimal)finalAcceptanceAmountNot.get()).add(orderGoodsEntity.getAcceptanceAmountNot()));
            }
        });
        Boolean falg = !entity.getGoodsList().stream().map(InvoiceAcceptanceGoodsEntity::getOrderStatus).collect(Collectors.toList()).contains(AcceptanceStatus.S100.getDictCode());
        if (entity.getFinalOrderAmount() == null && falg.booleanValue()) {
            entity.setFinalOrderAmount(finalOrderAmount.get());
        }
        if (entity.getFinalOrderAmountNot() == null && falg.booleanValue()) {
            entity.setFinalOrderAmountNot(finalOrderAmountNot.get());
        }
        BigDecimal acceptanceAmount = entity.getFinalAcceptanceAmount();
        if (falg.booleanValue() && (Objects.isNull(acceptanceAmount) || acceptanceAmount.compareTo(BigDecimal.ZERO) == 0)) {
            entity.setFinalAcceptanceAmount(finalAcceptanceAmount.get());
        }
        BigDecimal acceptanceAmountNot = entity.getFinalAcceptanceAmountNot();
        if (falg.booleanValue() && (Objects.isNull(acceptanceAmountNot) || acceptanceAmountNot.compareTo(BigDecimal.ZERO) == 0)) {
            entity.setFinalAcceptanceAmountNot(finalAcceptanceAmountNot.get());
        }
        this.invoiceAcceptanceGoodsRepository.deleteByKaOrderNumber(entity.getTenantCode(), entity.getKaOrderNumber());
        this.invoiceAcceptanceGoodsRepository.saveBatch(entity.getGoodsList());
    }

    private InvoiceAcceptanceGoodsEntity setAccount(InvoiceAcceptanceGoodsEntity orderGoodsEntity, BigDecimal decimal, Map<String, BigDecimal> map) {
        String goodsCode = orderGoodsEntity.getGoodsCode();
        if (!StringUtils.isEmpty((CharSequence)goodsCode)) {
            BigDecimal oneAmount;
            BigDecimal multiply;
            if (Objects.isNull(map)) {
                return orderGoodsEntity;
            }
            BigDecimal bigDecimal = map.get(goodsCode);
            if (Objects.isNull(bigDecimal)) {
                return orderGoodsEntity;
            }
            if (Objects.nonNull(orderGoodsEntity.getAcceptanceAmount()) && !orderGoodsEntity.getAcceptanceAmount().equals(BigDecimal.ZERO) && Objects.isNull(orderGoodsEntity.getAcceptanceAmountNot())) {
                BigDecimal amount = orderGoodsEntity.getAcceptanceAmount().divide(BigDecimal.ONE.add(bigDecimal), 4, 4);
                orderGoodsEntity.setAcceptanceAmountNot(amount);
            }
            BigDecimal acceptanceAmount = orderGoodsEntity.getAcceptanceAmount();
            BigDecimal acceptanceAmountNot = orderGoodsEntity.getAcceptanceAmountNot();
            if (Objects.nonNull(acceptanceAmount) && Objects.isNull(acceptanceAmountNot) && acceptanceAmount.compareTo(BigDecimal.ZERO) != 0) {
                multiply = acceptanceAmount.divide(decimal.add(bigDecimal).setScale(4, 4), 4, 4);
                orderGoodsEntity.setAcceptanceAmountNot(multiply);
            }
            if (Objects.nonNull(acceptanceAmountNot) && Objects.isNull(acceptanceAmount) && acceptanceAmountNot.compareTo(BigDecimal.ZERO) != 0) {
                multiply = acceptanceAmountNot.multiply(decimal.add(bigDecimal).setScale(4, 4));
                orderGoodsEntity.setAcceptanceAmount(multiply.setScale(4, 4));
            }
            if (Objects.isNull(orderGoodsEntity.getAcceptanceOneAmount()) && Objects.nonNull(orderGoodsEntity.getAcceptanceAmount()) && Objects.nonNull(orderGoodsEntity.getCurUnitAcceptanceQuantity()) && orderGoodsEntity.getCurUnitAcceptanceQuantity().compareTo(BigDecimal.ZERO) != 0 && orderGoodsEntity.getAcceptanceAmount().compareTo(BigDecimal.ZERO) != 0) {
                oneAmount = orderGoodsEntity.getAcceptanceAmount().divide(orderGoodsEntity.getCurUnitAcceptanceQuantity(), 4, 4);
                orderGoodsEntity.setAcceptanceOneAmount(oneAmount);
            }
            if (Objects.isNull(orderGoodsEntity.getAcceptanceOneAmountNot()) && Objects.nonNull(orderGoodsEntity.getAcceptanceAmountNot()) && Objects.nonNull(orderGoodsEntity.getCurUnitAcceptanceQuantity()) && orderGoodsEntity.getCurUnitAcceptanceQuantity().compareTo(BigDecimal.ZERO) != 0 && orderGoodsEntity.getAcceptanceAmountNot().compareTo(BigDecimal.ZERO) != 0) {
                oneAmount = orderGoodsEntity.getAcceptanceAmountNot().divide(orderGoodsEntity.getCurUnitAcceptanceQuantity(), 4, 4);
                orderGoodsEntity.setAcceptanceOneAmountNot(oneAmount);
            }
        }
        return orderGoodsEntity;
    }

    private void clearTransformItem(InvoiceAcceptanceGoodsEntity entity) {
        entity.setGoodsCode(null);
        entity.setGoodsName(null);
        entity.setOrderStatus(AcceptanceStatus.S100.getDictCode());
        entity.setId(null);
    }

    private DirectProductVo getGoodsInfo(InvoiceAcceptanceGoodsEntity orderGoodsEntity, InvoiceAcceptanceEntity entity, Map<String, List<DirectProductVo>> directProductMap, String deliveryCode) {
        List<DirectProductVo> productVos;
        DirectProductVo productVo = null;
        orderGoodsEntity.setDeliveryPartyCode(entity.getDeliveryPartyCode());
        orderGoodsEntity.setDeliveryPartyName(entity.getDeliveryPartyName());
        orderGoodsEntity.setDirectCode(entity.getDirectCode());
        if (StringUtils.isBlank((CharSequence)orderGoodsEntity.getKaGoodsCode())) {
            orderGoodsEntity.setOrderStatusMsg("\u5546\u8d85\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a");
            return null;
        }
        List<Object> productVoList = new ArrayList<DirectProductVo>();
        List<DirectProductVo> productVoLists = directProductMap.get(entity.getDirectCode() + "_" + entity.getDeliveryPartyCode() + "_" + orderGoodsEntity.getKaGoodsCode());
        if (CollectionUtil.isNotEmpty(productVoLists)) {
            productVoList.addAll(productVoLists);
        }
        if (CollectionUtil.isEmpty(productVoList) && StringUtils.isNotBlank((CharSequence)deliveryCode) && CollectionUtil.isNotEmpty(productVos = directProductMap.get(entity.getDirectCode() + "_" + deliveryCode + "_" + orderGoodsEntity.getKaGoodsCode()))) {
            productVoList.addAll(productVos);
        }
        if (CollectionUtil.isEmpty(productVoList)) {
            orderGoodsEntity.setOrderStatusMsg("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb");
        } else if (productVoList.size() == 1) {
            productVo = (DirectProductVo)productVoList.get(0);
        } else {
            int allSize = productVoList.size();
            if (CollectionUtil.isEmpty(productVoList = productVoList.stream().filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getIsDefault())).collect(Collectors.toList()))) {
                orderGoodsEntity.setOrderStatusMsg("\u5171[" + allSize + "]\u6761\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb,\u65e0\u9ed8\u8ba4\u5bf9\u5e94\u5173\u7cfb");
            } else if (productVoList.size() > 1) {
                orderGoodsEntity.setOrderStatusMsg("[" + productVoList.size() + "]\u6761\u9ed8\u8ba4\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb");
            } else {
                productVo = (DirectProductVo)productVoList.get(0);
            }
        }
        return productVo;
    }

    private void buildGoodsInfo(InvoiceAcceptanceGoodsEntity orderGoodsEntity, InvoiceAcceptanceEntity entity, DirectProductVo productVo) {
        if (Objects.isNull(productVo)) {
            return;
        }
        orderGoodsEntity.setGoodsCode(productVo.getProductCode());
        orderGoodsEntity.setGoodsName(productVo.getProductName());
        if (Objects.isNull(orderGoodsEntity.getCurUnitAcceptanceQuantity())) {
            orderGoodsEntity.setOrderStatusMsg("\u65e0\u9a8c\u6536\u6570\u91cf");
            return;
        }
        List unitList = productVo.getUnitList();
        if (CollectionUtils.isEmpty((Collection)unitList)) {
            orderGoodsEntity.setOrderStatusMsg("\u672a\u5339\u914d\u4f01\u4e1a\u5546\u54c1\u5355\u4f4d\u8f6c\u6362\u5173\u7cfb");
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)orderGoodsEntity.getCurUnit())) {
            unitList = unitList.stream().filter(vo -> Objects.nonNull(vo.getKaUnitQuantity()) && Objects.nonNull(vo.getUnitQuantity())).filter(vo -> Objects.equals(orderGoodsEntity.getCurUnit(), vo.getKaUnitCode())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)unitList)) {
            unitList = productVo.getUnitList().stream().filter(vo -> Objects.nonNull(vo.getKaUnitQuantity()) && Objects.nonNull(vo.getUnitQuantity())).filter(vo -> StringUtils.isBlank((CharSequence)vo.getKaUnitCode())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)unitList)) {
            orderGoodsEntity.setOrderStatusMsg("\u672a\u5339\u914d\u4f01\u4e1a\u5546\u54c1\u5355\u4f4d\u8f6c\u6362\u5173\u7cfb");
            return;
        }
        DirectProductUnitVo unitVo = (DirectProductUnitVo)unitList.get(0);
        if (Objects.isNull(orderGoodsEntity.getAcceptanceAmount()) || Objects.isNull(orderGoodsEntity.getCurUnitAcceptanceQuantity())) {
            orderGoodsEntity.setOrderStatusMsg("\u8be5\u9a8c\u6536\u5355\u660e\u7ec6\u7684\u91d1\u989d\u6216\u6570\u91cf\u4e3a\u7a7a");
        }
        if (ObjectUtils.isNotEmpty((Object)orderGoodsEntity.getCurUnitAcceptanceQuantity()) && Objects.nonNull(unitVo.getUnitQuantity()) && Objects.nonNull(unitVo.getKaUnitQuantity()) && orderGoodsEntity.getCurUnitAcceptanceQuantity().compareTo(BigDecimal.ZERO) != 0 && unitVo.getUnitQuantity().compareTo(BigDecimal.ZERO) != 0 && unitVo.getKaUnitQuantity().compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal curCompanyUnitOrderQuantityOne = orderGoodsEntity.getCurUnitAcceptanceQuantity().multiply(unitVo.getUnitQuantity());
            BigDecimal curCompanyUnitOrderQuantitytwo = curCompanyUnitOrderQuantityOne.divide(unitVo.getKaUnitQuantity(), 4, 4);
            orderGoodsEntity.setCurCompanyUnitOrderQuantity(curCompanyUnitOrderQuantitytwo);
        }
        orderGoodsEntity.setCurCompanyUnitCode(unitVo.getUnitCode());
        orderGoodsEntity.setCurCompanyUnitName(unitVo.getUnitName());
        orderGoodsEntity.setOrderStatus(AcceptanceStatus.S200.getDictCode());
        orderGoodsEntity.setOrderStatusMsg("\u8f6c\u6362\u6210\u529f");
    }

    private void setOrderStatusAndMsgFour(InvoiceAcceptanceEntity entity) {
        long errorCount = 0L;
        if (CollectionUtil.isNotEmpty(entity.getGoodsList())) {
            errorCount = entity.getGoodsList().stream().filter(k -> Objects.equals(AcceptanceStatus.S100.getDictCode(), k.getOrderStatus())).count();
        }
        if (errorCount > 0L) {
            entity.setOrderStatus(AcceptanceStatus.S100.getDictCode());
            String orderStatusMsg = entity.getOrderStatusMsg();
            orderStatusMsg = StringUtils.isNotBlank((CharSequence)orderStatusMsg) ? String.format("%s||%s", orderStatusMsg, "\u5546\u54c1\u884c\u4fe1\u606f\u5b58\u5728\u8f6c\u6362\u5931\u8d25\u6570\u636e") : "\u5546\u54c1\u884c\u4fe1\u606f\u5b58\u5728\u8f6c\u6362\u5931\u8d25\u6570\u636e";
            entity.setOrderStatusMsg(orderStatusMsg);
        } else if (Objects.equals(AcceptanceStatus.S200.getDictCode(), entity.getOrderStatus())) {
            entity.setOrderStatusMsg("\u8f6c\u6362\u6210\u529f");
        }
    }
}

