/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.acceptance.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceOrderImportsService;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceService;
import com.biz.crm.kms.business.invoice.acceptance.sdk.dto.InvoiceAcceptanceDto;
import com.biz.crm.kms.business.invoice.acceptance.sdk.dto.InvoiceAcceptanceOrderLogEventDto;
import com.biz.crm.kms.business.invoice.acceptance.sdk.event.InvoiceAcceptanceOrderLogEventListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class InvoiceAcceptanceOrderImportsServiceImpl
implements InvoiceAcceptanceOrderImportsService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceAcceptanceOrderImportsServiceImpl.class);
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private InvoiceAcceptanceService invoiceAcceptanceService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importsSave(List<InvoiceAcceptanceEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        log.info("\u6536\u5230\u9a8c\u6536\u5355\u6570\u636e");
        list.forEach(aa -> {
            aa.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            aa.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            aa.setTenantCode(TenantUtils.getTenantCode());
            aa.setInvoicesSource("\u624b\u52a8\u5bfc\u5165");
            log.info("\u5f00\u59cb\u4fdd\u5b58={}", (Object)JSON.toJSONString((Object)aa));
            this.invoiceAcceptanceService.create((InvoiceAcceptanceEntity)((Object)aa));
        });
        log.info("\u5f00\u59cb\u4fdd\u5b58\u65e5\u5fd7");
        Collection invoiceAcceptanceDtos = this.nebulaToolkitService.copyCollectionByWhiteList(list, InvoiceAcceptanceEntity.class, InvoiceAcceptanceDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        invoiceAcceptanceDtos.forEach(dto -> {
            InvoiceAcceptanceOrderLogEventDto logEventDto = new InvoiceAcceptanceOrderLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = InvoiceAcceptanceOrderLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, InvoiceAcceptanceOrderLogEventListener.class, (SerializableBiConsumer)onCreate);
        });
    }
}

