/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.acceptance.local.service.internal;

import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceGoodsEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.repository.InvoiceAcceptanceGoodsRepository;
import com.biz.crm.kms.business.invoice.acceptance.local.repository.InvoiceAcceptanceRepository;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceGoodsService;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceService;
import com.biz.crm.kms.business.invoice.acceptance.sdk.enums.AcceptanceStatus;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class InvoiceAcceptanceServiceImpl
implements InvoiceAcceptanceService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceAcceptanceServiceImpl.class);
    @Autowired(required=false)
    private InvoiceAcceptanceRepository invoiceAcceptanceRepository;
    @Autowired(required=false)
    private InvoiceAcceptanceGoodsService invoiceAcceptanceGoodsService;
    @Autowired(required=false)
    private InvoiceAcceptanceGoodsRepository invoiceAcceptanceGoodsRepository;

    @Override
    public InvoiceAcceptanceEntity findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        InvoiceAcceptanceEntity entity = this.invoiceAcceptanceRepository.findById(id);
        if (entity == null) {
            return null;
        }
        List<InvoiceAcceptanceGoodsEntity> goodsEntities = this.invoiceAcceptanceGoodsService.findByOrderNumber(entity.getOrderNumber());
        entity.setGoodsList(goodsEntities);
        return entity;
    }

    @Override
    public void transformation(InvoiceAcceptanceEntity entity) {
        InvoiceAcceptanceEntity oldEntity = this.invoiceAcceptanceRepository.findByKaOrderNumber(TenantUtils.getTenantCode(), entity.getKaOrderNumber());
        if (oldEntity != null) {
            Validate.isTrue((entity.getVersionNumber() > oldEntity.getVersionNumber() ? 1 : 0) != 0, (String)"\u5df2\u5b58\u5728\u66f4\u5927\u7248\u672c\u53f7\u8f6c\u6362\u8bb0\u5f55\uff01", (Object[])new Object[0]);
            Validate.isTrue((AcceptanceStatus.S100.getDictCode().equals(oldEntity.getOrderStatus()) || AcceptanceStatus.S101.getDictCode().equals(oldEntity.getOrderStatus()) || AcceptanceStatus.S200.getDictCode().equals(oldEntity.getOrderStatus()) ? 1 : 0) != 0, (String)String.format("\u5f53\u524d\u9a8c\u6536\u5355\u72b6\u6001[%s]\u4e0d\u80fd\u7ee7\u7eed\u8f6c\u6362\uff01", oldEntity.getOrderStatusMsg()), (Object[])new Object[0]);
            this.invoiceAcceptanceRepository.deleteByKaOrderNumber(TenantUtils.getTenantCode(), entity.getKaOrderNumber());
            this.invoiceAcceptanceGoodsService.deleteByKaOrderNumber(entity.getKaOrderNumber());
        }
        this.invoiceAcceptanceRepository.save((Object)entity);
        if (CollectionUtils.isNotEmpty(entity.getGoodsList())) {
            this.invoiceAcceptanceGoodsService.createBatch(entity.getGoodsList());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u8bf7\u9009\u62e9\u6570\u636e!", (Object[])new Object[0]);
        List<InvoiceAcceptanceEntity> entities = this.invoiceAcceptanceRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List<String> kaOrderNumbers = entities.stream().map(InvoiceAcceptanceEntity::getKaOrderNumber).distinct().collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(kaOrderNumbers), (String)"\u5546\u8d85\u9a8c\u6536\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        this.invoiceAcceptanceGoodsRepository.deleteByKaOrderNumbers(tenantCode, kaOrderNumbers);
        this.invoiceAcceptanceRepository.deleteByKaOrderNumbers(tenantCode, kaOrderNumbers);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public InvoiceAcceptanceEntity create(InvoiceAcceptanceEntity invoiceAcceptanceEntity) {
        this.createValidate(invoiceAcceptanceEntity);
        this.invoiceAcceptanceRepository.saveOrUpdate((Object)invoiceAcceptanceEntity);
        if (CollectionUtils.isNotEmpty(invoiceAcceptanceEntity.getGoodsList())) {
            invoiceAcceptanceEntity.getGoodsList().forEach(aa -> this.invoiceAcceptanceGoodsRepository.saveOrUpdate(aa));
        }
        return invoiceAcceptanceEntity;
    }

    private void createValidate(InvoiceAcceptanceEntity invoiceAcceptanceEntity) {
        Validate.notNull((Object)((Object)invoiceAcceptanceEntity), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)invoiceAcceptanceEntity.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)invoiceAcceptanceEntity.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)invoiceAcceptanceEntity.getKaName(), (String)"\u7cfb\u7edf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)invoiceAcceptanceEntity.getInvoicesSource(), (String)"\u5355\u636e\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        InvoiceAcceptanceEntity entity = this.invoiceAcceptanceRepository.findByKaOrderNumber(TenantUtils.getTenantCode(), invoiceAcceptanceEntity.getKaOrderNumber());
        Validate.isTrue((boolean)ObjectUtils.isEmpty((Object)((Object)entity)), (String)"\u8be5\u9a8c\u6536\u5355\u5b58\u5728", (Object[])new Object[0]);
        invoiceAcceptanceEntity.setId(null);
    }
}

