/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.acceptance.local.service.internal;

import com.biz.crm.kms.business.invoice.acceptance.local.entity.SapAcceptanceTestEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.SapResultTestEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.mapper.InvoiceAcceptanceTestMapper;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceTestService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvoiceAcceptanceTestServiceImpl
implements InvoiceAcceptanceTestService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceAcceptanceTestServiceImpl.class);
    @Autowired(required=false)
    private InvoiceAcceptanceTestMapper testMapper;

    @Override
    public void auditTest() {
        List<SapAcceptanceTestEntity> acceptanceVoList = this.testMapper.acceptanceVoList("");
        List<SapResultTestEntity> sapResultTestEntityList = this.testMapper.sapResultVoList("");
        HashMap<String, String> acceptanceMap = new HashMap<String, String>(acceptanceVoList.size());
        this.test(acceptanceVoList, sapResultTestEntityList, acceptanceMap, "CQMN0001", false, -1, 3);
        log.error("\u5339\u914d\u5b8c\u6210A => directCode[{}]", (Object)"CQMN0001");
        this.test(acceptanceVoList, sapResultTestEntityList, acceptanceMap, "HFMN0001", true, 0, 5);
        log.error("\u5339\u914d\u5b8c\u6210B => directCode[{}]", (Object)"HFMN0001");
        this.test(acceptanceVoList, sapResultTestEntityList, acceptanceMap, "JNMN0003", true, 0, 10);
        log.error("\u5339\u914d\u5b8c\u6210C => directCode[{}]", (Object)"JNMN0003");
    }

    private void test(List<SapAcceptanceTestEntity> acceptanceVoList, List<SapResultTestEntity> sapResultTestEntityList, Map<String, String> acceptanceMap, String directCode, boolean isTerminal, int beginDay, int endDay) {
        List acceptanceDirectList = acceptanceVoList.stream().filter(k -> directCode.equals(k.getDirectCode())).collect(Collectors.toList());
        sapResultTestEntityList.forEach(sap -> {
            int j = beginDay;
            while (j <= endDay) {
                int finalJ = j++;
                acceptanceDirectList.forEach(acc -> {
                    boolean flag = true;
                    long betweenDays = (acc.getOrderTime().getTime() - sap.getSapTime().getTime()) / 86400000L;
                    if ((long)finalJ != betweenDays) {
                        flag = false;
                    }
                    if (!sap.getProductCode().equals(acc.getProductCode())) {
                        flag = false;
                    }
                    if (!"CQMN0001".equals(acc.getDirectCode()) && !sap.getStoreCode().equals(acc.getStoreCode())) {
                        flag = false;
                    }
                    if (flag && (!acceptanceMap.containsKey(acc.getOrderNo()) || sap.getSapNo().equals(acceptanceMap.get(acc.getOrderNo())))) {
                        acceptanceMap.put(acc.getOrderNo(), sap.getSapNo());
                        sap.setOrderNo(acc.getOrderNo());
                        sap.setOrderTime(acc.getOrderTime());
                        sap.setDirectCode(acc.getDirectCode());
                        sap.setOrderStoreCode(acc.getStoreCode());
                        sap.setOrderProductCode(acc.getProductCode());
                        sap.setOrderAmount(acc.getAmount());
                        sap.setOrderQuantity(acc.getQuantity());
                        this.testMapper.updateById(sap);
                    }
                });
            }
        });
    }
}

