/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.acceptance.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.entity.InvoiceAcceptanceGoodsEntity;
import com.biz.crm.kms.business.invoice.acceptance.local.repository.InvoiceAcceptanceGoodsRepository;
import com.biz.crm.kms.business.invoice.acceptance.local.repository.InvoiceAcceptanceRepository;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceGrabService;
import com.biz.crm.kms.business.invoice.acceptance.local.service.InvoiceAcceptanceService;
import com.biz.crm.kms.business.invoice.acceptance.sdk.enums.AcceptanceStatus;
import com.biz.crm.kms.business.invoice.acceptance.sdk.service.InvoiceAcceptanceVoService;
import com.biz.crm.kms.business.invoice.acceptance.sdk.vo.InvoiceAcceptanceGoodsVo;
import com.biz.crm.kms.business.invoice.acceptance.sdk.vo.InvoiceAcceptanceVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class InvoiceAcceptanceVoServiceImpl
implements InvoiceAcceptanceVoService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceAcceptanceVoServiceImpl.class);
    @Autowired(required=false)
    private InvoiceAcceptanceService invoiceAcceptanceService;
    @Autowired(required=false)
    private InvoiceAcceptanceRepository invoiceAcceptanceRepository;
    @Autowired(required=false)
    private InvoiceAcceptanceGrabService invoiceAcceptanceGrabService;
    @Autowired(required=false)
    private InvoiceAcceptanceGoodsRepository invoiceAcceptanceGoodsRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public InvoiceAcceptanceVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        InvoiceAcceptanceEntity entity = this.invoiceAcceptanceService.findDetailById(id);
        if (entity == null) {
            return null;
        }
        InvoiceAcceptanceVo invoiceAcceptanceVo = (InvoiceAcceptanceVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, InvoiceAcceptanceVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isEmpty(entity.getGoodsList())) {
            return invoiceAcceptanceVo;
        }
        try {
            invoiceAcceptanceVo.setAcceptanceTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(invoiceAcceptanceVo.getAcceptanceDate()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        List goodsList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entity.getGoodsList(), InvoiceAcceptanceGoodsEntity.class, InvoiceAcceptanceGoodsVo.class, HashSet.class, ArrayList.class, new String[0]);
        invoiceAcceptanceVo.setGoodsList(goodsList);
        return invoiceAcceptanceVo;
    }

    public InvoiceAcceptanceVo findByDecomentCode(String code, String deliveryPartyCode) {
        if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)deliveryPartyCode)) {
            return null;
        }
        InvoiceAcceptanceEntity entity = this.invoiceAcceptanceRepository.findByDecomentCode(code, deliveryPartyCode);
        if (ObjectUtils.isEmpty((Object)((Object)entity))) {
            return null;
        }
        InvoiceAcceptanceVo invoiceAcceptanceVo = this.findDetailById(entity.getId());
        return invoiceAcceptanceVo;
    }

    public Page<InvoiceAcceptanceVo> findByDirectCodes(Pageable pageable, String tenantCode, List<String> directCodes) {
        return this.invoiceAcceptanceRepository.findAcceptanceByDirectCodes(pageable, tenantCode, directCodes);
    }

    public void manualSwitch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<InvoiceAcceptanceEntity> entities = this.invoiceAcceptanceRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(entities) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5", (Object[])new Object[0]);
        Validate.isTrue((!ObjectUtils.notEqual((Object)entities.size(), (Object)ids.size()) ? 1 : 0) != 0, (String)"\u6570\u636e\u8f6c\u6362\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        entities.forEach(entity -> Validate.isTrue((boolean)Lists.newArrayList((Object[])new String[]{AcceptanceStatus.S200.getDictCode(), AcceptanceStatus.S101.getDictCode(), AcceptanceStatus.S100.getDictCode()}).contains(entity.getOrderStatus()), (String)String.format("\u9a8c\u6536\u5355[%s]\u5df2\u786e\u8ba4,\u65e0\u6cd5\u7ee7\u7eed\u5339\u914d", entity.getOrderNumber()), (Object[])new Object[0]));
        List<String> orderNumbers = entities.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getOrderNumber())).map(InvoiceAcceptanceEntity::getOrderNumber).distinct().collect(Collectors.toList());
        this.invoiceAcceptanceGrabService.filterSwitchIngOrderNumberList(orderNumbers);
        log.info("===== \u9a8c\u6536\u5355\u624b\u52a8\u8f6c\u6362\u5f00\u59cb ======");
        this.invoiceAcceptanceGrabService.manualSwitch(orderNumbers);
        log.info("===== \u9a8c\u6536\u5355\u624b\u52a8\u8f6c\u6362\u5b8c\u6210 ======");
    }

    public void match(List<String> orderNumbers, String statementCode) {
        Validate.isTrue((!CollectionUtils.isEmpty(orderNumbers) && StringUtils.isNotBlank((CharSequence)statementCode) ? 1 : 0) != 0, (String)"\u9a8c\u6536\u5355\u53f7\u548c\u7ed3\u7b97\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.invoiceAcceptanceRepository.cancel(statementCode);
        this.invoiceAcceptanceRepository.match(orderNumbers, statementCode);
    }

    public List<InvoiceAcceptanceGoodsVo> findAllByConditions(List<String> goodsCodes, List<String> storeCodes, List<String> orderCodes, String beginDate, String endDate, List<String> soldToPartyCodes, List<String> directCodes) {
        return this.invoiceAcceptanceGoodsRepository.findAllByConditions(goodsCodes, storeCodes, orderCodes, beginDate, endDate, soldToPartyCodes, directCodes);
    }

    public List<InvoiceAcceptanceVo> findAcceptanceOrderVo(String beginDate, String endDate, List<String> directCodes) {
        return this.invoiceAcceptanceRepository.findAcceptanceOrderVo(beginDate, endDate, directCodes);
    }

    public List<InvoiceAcceptanceGoodsVo> findByOrderNumberOrRelationKaOrderNumber(List<String> orderNumbers, List<String> relationKaOrderNumber) {
        return this.invoiceAcceptanceGoodsRepository.findByOrderNumberOrRelationKaOrderNumber(orderNumbers, relationKaOrderNumber, TenantUtils.getTenantCode());
    }

    public void splitAcceptance(List<InvoiceAcceptanceVo> invoiceAcceptanceVos) {
        if (CollectionUtils.isEmpty(invoiceAcceptanceVos)) {
            return;
        }
        Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)invoiceAcceptanceVos.stream().filter(f -> StringUtils.isEmpty((CharSequence)f.getSplitBeforeId())).collect(Collectors.toList())), (String)"\u62c6\u5206\u5355\u636e\u4e2d\u539f\u59cb\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        InvoiceAcceptanceEntity entity = this.invoiceAcceptanceService.findDetailById(invoiceAcceptanceVos.get(0).getSplitBeforeId());
        if (Objects.isNull((Object)entity)) {
            return;
        }
        Validate.isTrue((boolean)AcceptanceStatus.S200.getDictCode().equals(entity.getOrderStatus()), (String)"\u8be5\u5355\u636e\u672a\u8f6c\u6362\u6210\u529f", (Object[])new Object[0]);
        Validate.isTrue((!BooleanEnum.TRUE.getCapital().equals(entity.getIsSplit()) ? 1 : 0) != 0, (String)"\u5df2\u62c6\u5206\u8fc7\u7684\u5355\u636e\u4e0d\u80fd\u518d\u6b21\u62c6\u5206", (Object[])new Object[0]);
        Set productNums = entity.getGoodsList().stream().map(InvoiceAcceptanceGoodsEntity::getGoodsCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(productNums)) {
            return;
        }
        HashMap productsMapTotal = Maps.newHashMap();
        HashMap productsUnitMapTotal = Maps.newHashMap();
        for (String product : productNums) {
            BigDecimal quentitys = entity.getGoodsList().stream().filter(f -> product.equals(f.getGoodsCode())).map(InvoiceAcceptanceGoodsEntity::getCurUnitAcceptanceQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal nowQunantitys = entity.getGoodsList().stream().filter(f -> product.equals(f.getGoodsCode())).map(InvoiceAcceptanceGoodsEntity::getCurCompanyUnitOrderQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            productsMapTotal.put(product, quentitys);
            productsUnitMapTotal.put(product, nowQunantitys.divide(quentitys, 10, 4));
        }
        HashSet goods = Sets.newHashSet();
        HashMap productsMap = Maps.newHashMap();
        Integer integer = 1;
        String acceptanceSplitOrders = "";
        ArrayList<InvoiceAcceptanceEntity> entities = new ArrayList<InvoiceAcceptanceEntity>();
        ArrayList invoiceAcceptanceGoodsEntityList = new ArrayList();
        for (InvoiceAcceptanceVo invoiceAcceptanceVo : invoiceAcceptanceVos) {
            Object good22;
            invoiceAcceptanceVo.setId(null);
            invoiceAcceptanceVo.setAcceptanceSplitOrders(null);
            invoiceAcceptanceVo.setIsSlips(BooleanEnum.TRUE.getCapital());
            invoiceAcceptanceVo.setTenantCode(TenantUtils.getTenantCode());
            invoiceAcceptanceVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            invoiceAcceptanceVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            invoiceAcceptanceVo.setOrderNumber(entity.getOrderNumber() + "-" + integer);
            invoiceAcceptanceVo.setKaOrderNumber(entity.getKaOrderNumber() + "-" + integer);
            if (StringUtils.isNotBlank((CharSequence)entity.getRelateOrderNumber())) {
                invoiceAcceptanceVo.setRelateOrderNumber(entity.getRelateOrderNumber() + "-" + integer);
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getRelateKaOrderNumber())) {
                invoiceAcceptanceVo.setRelateKaOrderNumber(entity.getRelateKaOrderNumber() + "-" + integer);
            }
            invoiceAcceptanceVo.setFinalAcceptanceAmount(BigDecimal.ZERO);
            invoiceAcceptanceVo.setFinalAcceptanceAmountNot(BigDecimal.ZERO);
            goods.addAll(invoiceAcceptanceVo.getGoodsList().stream().map(InvoiceAcceptanceGoodsVo::getGoodsCode).collect(Collectors.toSet()));
            BigDecimal quentitys = BigDecimal.ZERO;
            for (Object good22 : goods) {
                if (CollectionUtils.isEmpty((Collection)invoiceAcceptanceVo.getGoodsList().stream().filter(arg_0 -> InvoiceAcceptanceVoServiceImpl.lambda$splitAcceptance$5((String)good22, arg_0)).collect(Collectors.toSet()))) {
                    return;
                }
                BigDecimal nums = invoiceAcceptanceVo.getGoodsList().stream().filter(arg_0 -> InvoiceAcceptanceVoServiceImpl.lambda$splitAcceptance$6((String)good22, arg_0)).map(InvoiceAcceptanceGoodsVo::getCurUnitAcceptanceQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                quentitys = quentitys.add(nums);
                if (Objects.nonNull(productsMap.get(good22))) {
                    BigDecimal quentity = (BigDecimal)productsMap.get(good22);
                    quentity = quentity.add(quentitys);
                    productsMap.put(good22, quentity);
                } else {
                    productsMap.put(good22, quentitys);
                }
                quentitys = BigDecimal.ZERO;
            }
            invoiceAcceptanceVo.getGoodsList().forEach(aa -> {
                aa.setId(null);
                aa.setOrderNumber(acceptanceVo.getOrderNumber());
                aa.setKaOrderNumber(acceptanceVo.getKaOrderNumber());
                if (Objects.nonNull(productsUnitMapTotal.get(aa.getGoodsCode()))) {
                    aa.setCurCompanyUnitOrderQuantity(aa.getCurUnitAcceptanceQuantity().multiply((BigDecimal)productsUnitMapTotal.get(aa.getGoodsCode())).setScale(4, 4));
                }
                aa.setOrderQuantity(aa.getCurUnitAcceptanceQuantity());
                Validate.isTrue((!Objects.isNull(aa.getCurUnitAcceptanceQuantity()) ? 1 : 0) != 0, (String)"\u8be5\u9a8c\u6536\u5355\u7684\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.isTrue((!Objects.isNull(aa.getAcceptanceOneAmount()) ? 1 : 0) != 0, (String)"\u8be5\u9a8c\u6536\u5355\u7684\u5355\u4ef7\uff08\u542b\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.isTrue((!Objects.isNull(aa.getAcceptanceOneAmountNot()) ? 1 : 0) != 0, (String)"\u8be5\u9a8c\u6536\u5355\u7684\u5355\u4ef7\uff08\u4e0d\u542b\u7a0e\uff09\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                aa.setAcceptanceAmount(aa.getAcceptanceOneAmount().multiply(aa.getCurUnitAcceptanceQuantity()));
                aa.setAcceptanceAmountNot(aa.getAcceptanceOneAmountNot().multiply(aa.getCurUnitAcceptanceQuantity()));
                acceptanceVo.setFinalAcceptanceAmount(acceptanceVo.getFinalAcceptanceAmount().add(aa.getAcceptanceAmount()));
                acceptanceVo.setFinalAcceptanceAmountNot(acceptanceVo.getFinalAcceptanceAmountNot().add(aa.getAcceptanceAmountNot()));
            });
            acceptanceSplitOrders = "".equals(acceptanceSplitOrders) ? acceptanceSplitOrders + invoiceAcceptanceVo.getOrderNumber() : acceptanceSplitOrders + "," + invoiceAcceptanceVo.getOrderNumber();
            Integer n = integer;
            integer = integer + 1;
            good22 = integer;
            InvoiceAcceptanceEntity invoiceAcceptanceEntity = (InvoiceAcceptanceEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)invoiceAcceptanceVo, InvoiceAcceptanceEntity.class, HashSet.class, ArrayList.class, new String[0]));
            List invoiceAcceptanceGoodsEntities = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)invoiceAcceptanceVo.getGoodsList(), InvoiceAcceptanceGoodsVo.class, InvoiceAcceptanceGoodsEntity.class, HashSet.class, ArrayList.class, new String[0]);
            invoiceAcceptanceGoodsEntityList.addAll(invoiceAcceptanceGoodsEntities);
            entities.add(invoiceAcceptanceEntity);
        }
        Validate.isTrue((productNums.size() == goods.size() ? 1 : 0) != 0, (String)"\u539f\u9a8c\u6536\u5355\u4e2d\u7684\u4ea7\u54c1\u6570\u91cf\u548c\u62c6\u5206\u9a8c\u6536\u5355\u4e2d\u7684\u4ea7\u54c1\u6570\u91cf\u5bf9\u4e0d\u4e0a", (Object[])new Object[0]);
        for (Map.Entry entry : productsMapTotal.entrySet()) {
            Validate.isTrue((boolean)Objects.nonNull(productsMap.get(entry.getKey())), (String)"\u539f\u9a8c\u6536\u5355\u4e2d\u7684\u4ea7\u54c1\u5728\u62c6\u5206\u540e\u7684\u9a8c\u6536\u5355\u4e2d\u672a\u51fa\u73b0", (Object[])new Object[0]);
            Validate.isTrue((((BigDecimal)entry.getValue()).compareTo((BigDecimal)productsMap.get(entry.getKey())) == 0 ? 1 : 0) != 0, (String)"\u539f\u9a8c\u6536\u5355\u4e2d\u7684\u4ea7\u54c1\u5728\u62c6\u5206\u540e\u7684\u9a8c\u6536\u5355\u4e2d\u6570\u91cf\u5bf9\u4e0d\u4e0a", (Object[])new Object[0]);
        }
        entity.setOrderStatus(AcceptanceStatus.S300.getDictCode());
        entity.setOrderStatusMsg("\u62c6\u5355\u6210\u529f");
        entity.setAcceptanceSplitOrders(acceptanceSplitOrders);
        entity.setIsSplit(BooleanEnum.TRUE.getCapital());
        this.invoiceAcceptanceRepository.saveOrUpdate((Object)entity);
        this.invoiceAcceptanceRepository.saveBatch(entities);
        this.invoiceAcceptanceGoodsRepository.saveBatch(invoiceAcceptanceGoodsEntityList);
    }

    public void withdrawSplit(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        InvoiceAcceptanceEntity invoiceAcceptanceEntity = this.invoiceAcceptanceService.findDetailById(id);
        if (Objects.isNull((Object)invoiceAcceptanceEntity)) {
            return;
        }
        InvoiceAcceptanceEntity entity = this.invoiceAcceptanceService.findDetailById(invoiceAcceptanceEntity.getSplitBeforeId());
        Validate.isTrue((!Objects.isNull((Object)entity) ? 1 : 0) != 0, (String)"\u8be5\u9a8c\u6536\u5355\u672a\u627e\u5230\u539f\u9a8c\u6536\u5355", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)entity.getAcceptanceSplitOrders()), (String)"\u8be5\u5b50\u9a8c\u6536\u5355\u4e0e\u539f\u9a8c\u6536\u5355\u672a\u5173\u8054\u4e0a", (Object[])new Object[0]);
        Object[] orderNumbers = entity.getAcceptanceSplitOrders().split(",");
        this.invoiceAcceptanceRepository.deleteByOrderNumbers(TenantUtils.getTenantCode(), Lists.newArrayList((Object[])orderNumbers));
        this.invoiceAcceptanceGoodsRepository.deleteByOrderNumbers(TenantUtils.getTenantCode(), Lists.newArrayList((Object[])orderNumbers));
        entity.setOrderStatus(AcceptanceStatus.S200.getDictCode());
        entity.setOrderStatusMsg("\u8f6c\u6362\u6210\u529f");
        entity.setAcceptanceSplitOrders("");
        entity.setIsSplit("");
        this.invoiceAcceptanceRepository.saveOrUpdate((Object)entity);
    }

    private static /* synthetic */ boolean lambda$splitAcceptance$6(String good, InvoiceAcceptanceGoodsVo f) {
        return good.equals(f.getGoodsCode());
    }

    private static /* synthetic */ boolean lambda$splitAcceptance$5(String good, InvoiceAcceptanceGoodsVo f) {
        return good.equals(f.getGoodsCode());
    }
}

