package com.biz.crm.kms.business.invoice.acceptance.sdk.constant;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * 订货单常量类
 *
 * @author cyj
 * @date 2022/11/29
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class AcceptanceOrderConstant {

    /**
     * KMS单据验收单 MQ topic
     */
    public static final String KMS_ACCEPTANCE_ORDER_TOPIC = "KMS_ACCEPTANCE_ORDER_TOPIC";

    /**
     * 验收单转换成功描述
     */
    public static final String ACCEPTANCE_ORDER_CONVERT_SUCCESS_MSG = "转换成功";

    /**
     * 验收单redis锁定时间
     */
    public static final Integer ACCEPTANCE_ORDER_REDIS_TIME = 1800;

    /**
     * 验收单自动转换 分页size
     */
    public static final Integer ACCEPTANCE_ORDER_PAGE_SIZE = 800;
    /**
     * 验收单自动转换 分页后最大循环次数  和 上个参数配合使用
     * 自动转换单词最大自动转换数量为   {@link ACCEPTANCE_ORDER_PAGE_SIZE }*{@link ACCEPTANCE_ORDER_LOOP_MAX }
     */
    public static final Integer ACCEPTANCE_ORDER_LOOP_MAX = 1000;

    /**
     * 验收单消息tag
     */
    public static final String ACCEPTANCE_ORDER_MESSAGE_TAG = "KMS_ACCEPTANCE_ORDER_MESSAGE_TAG";

    /**
     * 验收单自动转换redis锁前缀
     */
    public static final String ACCEPTANCE_ORDER_AUTO_NOT_CONVERT_LOCK = "KMS:ACCEPTANCE:ORDER:AUTO_NOT_CONVERT:LOCK";
    
    /**
     * 验收单自动转换redis锁前缀
     */
    public static final String ACCEPTANCE_ORDER_AUTO_FAIL_CONVERT_LOCK = "KMS:ACCEPTANCE:ORDER:AUTO_FAIL_CONVERT:LOCK";

    /**
     * 验收单redis锁前缀
     */
    public static final String ACCEPTANCE_ORDER_CONVERT_LOCK = "KMS:ACCEPTANCE:ORDER:CONVERT:LOCK:";
    /**
     * 缓存税率的key
     */
    public static final String CACHE_PRODUCT_TAX_RATE = "KMS:CACHE:PRODUCT_TAX_RATE";

    public static final String ACCEPTANCE_SPILT_MSG = "拆单成功";
}
