package com.biz.crm.kms.business.invoice.acceptance.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 验收单表dto
 *
 * @author pengxi
 * @date 2022/10/10
 */
@Data
@ApiModel(value = "InvoiceAcceptanceDto", description = "验收单表dto")
public class InvoiceAcceptanceDto extends TenantFlagOpDto {

  @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
  private String rawDataId;

  /**
   * [数据字典:mdm_business_format]
   */
  @ApiModelProperty("业态")
  private String businessFormatCode;

  /**
   * [数据字典:mdm_business_unit]
   */
  @ApiModelProperty("业务单元编码")
  private String businessUnitCode;

  @ApiModelProperty("业务单元名称")
  private String businessUnitName;

  @ApiModelProperty("关联结算单号")
  private String statementCode;

  @ApiModelProperty("稽核日期")
  private Date auditDate;

  @ApiModelProperty("转换状态")
  private String orderStatus;

  @ApiModelProperty("转换状态描述")
  private String orderStatusMsg;

  @ApiModelProperty("系统编码")
  private String directCode;

  @ApiModelProperty("关联企业订货单编号")
  private String relateOrderNumber;

  @ApiModelProperty("关联商超订货单编号")
  private String relateKaOrderNumber;

  @ApiModelProperty("企业验收单编号")
  private String orderNumber;

  @ApiModelProperty("商超验收单编号")
  private String kaOrderNumber;

  @ApiModelProperty("验收日期")
  private String acceptanceDate;

  @ApiModelProperty("验收日期(页面用)")
  private String acceptanceTime;

  @ApiModelProperty("验收类型")
  private String acceptanceType;

  @ApiModelProperty("单据来源")
  private String invoicesSource;

  @ApiModelProperty("商超编码")
  private String kaCode;

  @ApiModelProperty("商超名称")
  private String kaName;

  @ApiModelProperty("商超门店/大仓编号")
  private String kaStoreCode;

  @ApiModelProperty("商超门店/大仓名称")
  private String kaStoreName;

  @ApiModelProperty("企业门店/大仓编号")
  private String storeCode;

  @ApiModelProperty("企业门店/大仓名称")
  private String storeName;

  @ApiModelProperty("订货单总金额（含税）")
  private BigDecimal finalOrderAmount;

  @ApiModelProperty("订货单总金额（不含税）")
  private BigDecimal finalOrderAmountNot;

  @ApiModelProperty("验收单总金额（含税）")
  private BigDecimal finalAcceptanceAmount;

  @ApiModelProperty("验收单总金额（不含税）")
  private BigDecimal finalAcceptanceAmountNot;

  @ApiModelProperty("业务区域负责人")
  private String businessAreaLeader;

  @ApiModelProperty("业务区域")
  private String businessArea;

  @ApiModelProperty("区域编码")
  private String areaCode;

  @ApiModelProperty("区域名称")
  private String areaName;

  @ApiModelProperty("售达方名称")
  private String soldToPartyName;

  @ApiModelProperty("售达方编码")
  private String soldToPartyCode;

  @ApiModelProperty("送达方编码")
  private String deliveryPartyCode;

  @ApiModelProperty("送达方名称")
  private String deliveryPartyName;

  @ApiModelProperty("登录账号")
  private String userName;

  @ApiModelProperty("供应商名称")
  private String supplierName;

  @ApiModelProperty("供应商编码")
  private String supplierCode;

  @ApiModelProperty("单据版本号")
  private Integer versionNumber;

  /**
   * 验收单商品集合
   */
  @ApiModelProperty("验收单商品集合")
  List<InvoiceAcceptanceGoodsDto> goodsList;
}

