package com.biz.crm.kms.business.invoice.acceptance.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 验收单商品表dto
 *
 * @author pengxi
 * @date 2022/10/10
 */
@Data
@ApiModel(value = "InvoiceAcceptanceGoodsDto", description = "验收单商品表dto")
public class InvoiceAcceptanceGoodsDto extends TenantFlagOpDto {

  @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
  private String rawDataId;

  @ApiModelProperty("转换状态")
  private String orderStatus;

  @ApiModelProperty("转换状态描述")
  private String orderStatusMsg;

  @ApiModelProperty("稽核日期")
  private Date auditDate;

  @ApiModelProperty("企业当前单位编码")
  private String curCompanyUnitCode;

  @ApiModelProperty("企业当前单位名称")
  private String curCompanyUnitName;

  @ApiModelProperty("企业当前单位订货数量")
  private BigDecimal curCompanyUnitOrderQuantity;

  @ApiModelProperty("企业单位数量")
  private BigDecimal numerator;

  @ApiModelProperty("企业验收单编号")
  private String orderNumber;

  @ApiModelProperty("商超验收单编号")
  private String kaOrderNumber;

  @ApiModelProperty("企业产品编号")
  private String goodsCode;

  @ApiModelProperty("企业产品名称")
  private String goodsName;

  @ApiModelProperty("商超产品编号")
  private String kaGoodsCode;

  @ApiModelProperty("商超产品名称")
  private String kaGoodsName;

  @ApiModelProperty("产品国际条码")
  private String goodsBarCode;

  @ApiModelProperty("产品规格")
  private String specification;

  @ApiModelProperty("当前单位验收数量")
  private BigDecimal curUnitAcceptanceQuantity;

  @ApiModelProperty("当前单位")
  private String curUnit;

  @ApiModelProperty("当前单位层级")
  private String curUnitLevel;

  @ApiModelProperty("订货数量")
  private BigDecimal orderQuantity;

  @ApiModelProperty("订货金额小计（含税）")
  private BigDecimal orderAmount;

  @ApiModelProperty("验收金额小计（含税）")
  private BigDecimal acceptanceAmount;

  @ApiModelProperty("订货金额小计（不含税）")
  private BigDecimal orderAmountNot;

  @ApiModelProperty("验收金额小计（不含税）")
  private BigDecimal acceptanceAmountNot;

  @ApiModelProperty("售达方名称")
  private String soldToPartyName;

  @ApiModelProperty("售达方编码")
  private String soldToPartyCode;

  @ApiModelProperty("商超编码")
  private String kaCode;

  @ApiModelProperty("商超名称")
  private String kaName;

  @ApiModelProperty("行信息排序")
  private Integer itemIndex;

  @ApiModelProperty("单据版本号")
  private Integer versionNumber;
}

