package com.biz.crm.kms.business.invoice.acceptance.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.invoice.acceptance.sdk.vo.InvoiceAcceptanceGoodsVo;
import com.biz.crm.kms.business.invoice.acceptance.sdk.vo.InvoiceAcceptanceVo;
import com.biz.crm.kms.business.invoice.sdk.vo.InvoiceStatisticsVo;
import org.springframework.data.domain.Pageable;

import java.util.List;


/**
 * 直营上架产品管理表(InvoiceAcceptance)表服务接口
 *
 * @author pengxi
 * @date 2022/10/10
 */
public interface InvoiceAcceptanceVoService {

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  InvoiceAcceptanceVo findDetailById(String id);

  /**
   * 通过编码查详情
   * @param code
   * @return
   */
  InvoiceAcceptanceVo findByDecomentCode(String code, String deliveryPartyCode);

  /**
   * 根据系统编码分页查询验收单
   * @param pageable
   * @param tenantCode
   * @return
   */
  Page<InvoiceAcceptanceVo> findByDirectCodes(Pageable pageable, String tenantCode,List<String> directCodes);

  /**
   * 手动转换
   *
   * @param ids
   * @return
   */
  void manualSwitch(List<String> ids);

  /**
   * 关联结算单
   * @param orderNumbers
   * @param statementCode
   */
  void match(List<String> orderNumbers,String statementCode);

  /**
   * 根据条件查询单据包含转换失败
   *
   * @param goodsCodes
   * @param storeCodes
   * @param orderCodes
   * @param beginDate
   * @param endDate
   * @param soldToPartyCodes
   * @param directCodes
   * @return
   */
  List<InvoiceAcceptanceGoodsVo> findAllByConditions(List<String> goodsCodes, List<String> storeCodes, List<String> orderCodes, String beginDate, String endDate, List<String> soldToPartyCodes, List<String> directCodes);

  /**
   * 查询验收单头明细数量
   * @param beginDate
   * @param endDate
   * @param directCodes
   * @return
   */
  List<InvoiceAcceptanceVo> findAcceptanceOrderVo(String beginDate, String endDate, List<String> directCodes);



  /**
   * 拆单逻辑：
   * 1.校验是否转换成功
   * 2.是否已经拆过单
   * 3.校验子单中产品的金额和数量
   * 4.存储：改变原单状态，并且不能够继续拆单
   * 5.将新生成的子验收单保持到原验收单中
   */

  public void splitAcceptance(List<InvoiceAcceptanceVo> invoiceAcceptanceVos);

  /**
   * 撤销拆分验收单
   * @param id
   */
  public void withdrawSplit(String id);

  /**
   * 根据验收单编码集合或采购单号集合查询验收单
   * @param orderNumbers
   * @param relationKaOrderNumber
   * @return
   */
  List<InvoiceAcceptanceGoodsVo> findByOrderNumberOrRelationKaOrderNumber(List<String> orderNumbers,List<String> relationKaOrderNumber);
}
