package com.biz.crm.kms.business.invoice.expense.sheet.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.invoice.expense.sheet.feign.feign.internal.InvoiceExpenseSheetVoFeignImpl;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 *
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-kms}",
        path = "crm-kms",
        fallbackFactory = InvoiceExpenseSheetVoFeignImpl.class)
public interface InvoiceExpenseSheetVoFeign {
    /**
    * @Description: 根据条件查询费用单
    * @Param: [dto]
    * @return: com.biz.crm.business.common.sdk.model.Result<java.util.List<com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto>>
    * @Author: ZS
    * @Date: 2022/11/16
    */
    @GetMapping("/v1/invoiceExpenseSheetVo/invoiceExpenseSheetVo/findExpenseSheet")
    Result<List<InvoiceExpenseSheetDto>> findExpenseSheet(@RequestParam InvoiceExpenseSheetDto dto);
    /**
     * @Description: 分页查询费用单
     * @Param: [pageNumber]
     * @Param: [pageSize]
     * @Param: [dto]
     * @return: com.biz.crm.business.common.sdk.model.Result<com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto>>
     * @Author: heding
     * @Date: 2022/11/30
     */
    @ApiOperation(value = "分页查询费用单")
    @GetMapping(value = {"/v1/invoiceExpenseSheetVo/invoiceExpenseSheetVo/findExpenseSheetPaging"})
    Result<Page<InvoiceExpenseSheetDto>> findExpenseSheetPaging(@PageableDefault(50) Pageable pageable,
                                                                @SpringQueryMap InvoiceExpenseSheetDto dto);
}
