package com.biz.crm.kms.business.invoice.expense.sheet.feign.feign.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.invoice.expense.sheet.feign.feign.InvoiceExpenseSheetVoFeign;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Class InvoiceExpenseSheetVoFeignImpl
 * @Description
 * @Author : ZS
 * @Date: 2022/11/16  14:49
 */
@Component
public class InvoiceExpenseSheetVoFeignImpl implements FallbackFactory<InvoiceExpenseSheetVoFeign> {

    @Override
    public InvoiceExpenseSheetVoFeign create(Throwable throwable) {
        return new InvoiceExpenseSheetVoFeign() {

            /**
            * @Description: 根据条件查询费用单
            * @Param: [dto]
            * @return: com.biz.crm.business.common.sdk.model.Result<java.util.List<com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto>>
            * @Author: ZS
            * @Date: 2022/11/16
            */
            @Override
            public Result<List<InvoiceExpenseSheetDto>> findExpenseSheet(InvoiceExpenseSheetDto dto) {
                throw new UnsupportedOperationException("根据条件查询费用单发生熔断");
            }
            /**
             * @Description: 分页查询费用单
             * @Param: [pageNumber]
             * @Param: [pageSize]
             * @Param: [dto]
             * @return: com.biz.crm.business.common.sdk.model.Result<com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto>>
             * @Author: heding
             * @Date: 2022/11/30
             */
            @Override
            public Result<Page<InvoiceExpenseSheetDto>> findExpenseSheetPaging(Pageable pageable, InvoiceExpenseSheetDto dto) {
                throw new UnsupportedOperationException("分页查询费用单发生熔断");
            }
        };
    }
}
