package com.biz.crm.kms.business.invoice.expense.sheet.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.invoice.expense.sheet.feign.feign.InvoiceExpenseSheetVoFeign;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.service.InvoiceExpenseSheetVoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @Class InvoiceExpenseSheetVoServiceImpl
 * @Description
 * @Author : ZS
 * @Date: 2022/11/16  14:30
 */
@Service
@Slf4j
public class InvoiceExpenseSheetVoServiceImpl implements InvoiceExpenseSheetVoService {

    @Autowired
    private InvoiceExpenseSheetVoFeign invoiceExpenseSheetVoFeign;

    /**
    * @Description: 根据条件查询费用单
    * @Param: [invoiceExpenseSheetDto]
    * @return: java.util.List<com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto>
    * @Author: ZS
    * @Date: 2022/11/16
    */
    @Override
    public List<InvoiceExpenseSheetDto> findExpenseSheet(InvoiceExpenseSheetDto invoiceExpenseSheetDto) {
        return this.invoiceExpenseSheetVoFeign.findExpenseSheet(invoiceExpenseSheetDto).getResult();
    }
    /**
     * @Description: 分页查询费用单
     * @Param: [pageable]
     * @Param: [dto]
     * @return: com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto>
     * @Author: heding
     * @Date: 2022/11/30
     */
    @Override
    public Page<InvoiceExpenseSheetDto> findExpenseSheetPaging(Pageable pageable, InvoiceExpenseSheetDto dto) {
        Result<Page<InvoiceExpenseSheetDto>> result = invoiceExpenseSheetVoFeign.findExpenseSheetPaging(pageable, dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public void manualSwitch(List<String> ids) {

    }

    @Override
    public void match(List<String> orderNumbers, String statementCode) {

    }

    @Override
    public List<String> syncExpense(List<String> directCodes) {
        return null;
    }

    @Override
    public void updateExpense(Map<String, BigDecimal> amounts, List<String> decomentCodes) {

    }

    @Override
    public Map<String, String> findCashing(Set<String> documentCodes) {
        return null;
    }
}
