package com.biz.crm.kms.business.invoice.expense.sheet.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.kms.business.invoice.expense.sheet.local.entity.InvoiceExpenseSheet;
import com.biz.crm.kms.business.invoice.expense.sheet.local.service.InvoiceExpenseSheetGrabService;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.constant.ExpenseSheetConstant;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Title: ReturnOrderConsumer
 * @Package: com.biz.crm.kms.business.invoice.returns.order.local.consumer
 * @Description:
 * @Author: wuxia
 * @Date: 2022/11/23 - 5:47 PM
 */

@Slf4j
@Component
@RocketMQMessageListener(topic = ExpenseSheetConstant.KMS_EXPENSE_SHEET_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = ExpenseSheetConstant.EXPENSE_SHEET_MESSAGE_TAG,
        /**
         * 相同分组下 consumer 可自动负载均衡
        */
        consumerGroup = ExpenseSheetConstant.EXPENSE_SHEET_MESSAGE_TAG + "${rocketmq.environment}",
        /**
         * 默认集群消费
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class ExpenseSheetConsumer extends AbstractRocketMqConsumer {

    @Autowired
    private InvoiceExpenseSheetGrabService invoiceExpenseSheetGrabService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("费用单自动转换MQ接收成功;单号集合[{}]", message.getMsgBody());
        try {
            List<String> orderNumberList = JSON.parseArray(message.getMsgBody(), String.class);
            log.info("===== 费用单自动转换开始 ======");
            this.invoiceExpenseSheetGrabService.manualSwitch(orderNumberList);
            log.info("===== 费用单自动转换完成 ======");
        } catch (Exception e) {
            log.error("", e);
        }
        return "消费成功";
    }
}
