package com.biz.crm.kms.business.invoice.expense.sheet.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.invoice.expense.sheet.local.service.InvoiceExpenseSheetGrabService;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.service.InvoiceExpenseSheetVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Class InvoiceExpenseSheetVoController
 * @Description 单据--费用单Vo控制层
 * @Author : ZS
 * @Date: 2022/11/16  14:33
 */
@RestController
@Slf4j
@Api(tags = "单据--费用单Vo控制层")
@RequestMapping("/v1/invoiceExpenseSheetVo/invoiceExpenseSheetVo")
public class InvoiceExpenseSheetVoController {

    @Autowired
    private InvoiceExpenseSheetVoService invoiceExpenseSheetVoService;

    @Autowired
    private InvoiceExpenseSheetGrabService service;

    /**
    * @Description: 根据条件查询费用单
    * @Param: [dto]
    * @return: com.biz.crm.business.common.sdk.model.Result<List<InvoiceExpenseSheetDto>>
    * @Author: ZS
    * @Date: 2022/11/16
    */
    @ApiOperation(value = "根据条件查询费用单")
    @GetMapping("/findExpenseSheet")
    public Result<List<InvoiceExpenseSheetDto>> findExpenseSheet(@RequestParam InvoiceExpenseSheetDto dto){
        try {
            List<InvoiceExpenseSheetDto> invoiceExpenseSheetDtoList = this.invoiceExpenseSheetVoService.findExpenseSheet(dto);
            return Result.ok(invoiceExpenseSheetDtoList);
        }catch (RuntimeException e){
            log.info(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 费用单手动转换
     * @param ids
     * @return
     */
    @ApiOperation(value = "费用单手动转换")
    @PatchMapping(value = {"/manualSwitch"})
    public Result<?> manualSwitch(@RequestBody List<String> ids) {
        try {
            this.invoiceExpenseSheetVoService.manualSwitch(ids);
            return Result.ok("转换结束");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
    /**
     * @Description: 分页查询费用单
     * @Param: [pageable]
     * @Param: [dto]
     * @return: com.biz.crm.business.common.sdk.model.Result<com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto>>
     * @Author: heding
     * @Date: 2022/11/30
     */
    @ApiOperation(value = "分页查询费用单")
    @GetMapping("/findExpenseSheetPaging")
    public Result<Page<InvoiceExpenseSheetDto>> findExpenseSheetPaging(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable, @RequestBody(required = false) InvoiceExpenseSheetDto dto){
        try {
            Page<InvoiceExpenseSheetDto> page = this.invoiceExpenseSheetVoService.findExpenseSheetPaging(pageable,dto);
            return Result.ok(page);
        }catch (RuntimeException e){
            log.info(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("手动触发定时任务")
    @GetMapping("autoJob")
    public void autoJob(){
        this.service.autoNotConvertExpenseSheet();
    }

}
