package com.biz.crm.kms.business.invoice.expense.sheet.local.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Class InvoiceExpenseSheet
 * @Description 单据展示-费用单
 * @Author : ZS
 * @Date: 2022/11/10  17:56
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName(value = "kms_invoice_expense_sheet")
@Table(name = "kms_invoice_expense_sheet", indexes = {
        @Index(name = "kms_invoice_expense_sheet_idx1", columnList = "tenant_code,invoice_expense_sheet_code"),
        @Index(name = "kms_invoice_expense_sheet_idx2", columnList = "supermarket_store_code"),
        @Index(name = "kms_invoice_expense_sheet_idx3", columnList = "ka_product_code"),
        @Index(name = "kms_invoice_expense_sheet_idx4", columnList = "statement_code"),
        @Index(name = "kms_invoice_expense_sheet_idx5", columnList = "direct_code"),

})
@ApiModel(value = "InvoiceExpenseSheet", description = "单据展示-费用单")
@org.hibernate.annotations.Table(appliesTo = "kms_invoice_expense_sheet", comment = "单据展示-费用单")
public class InvoiceExpenseSheet extends TenantFlagOpEntity {

    /**
     * 原始数据ID
     */
    @ApiModelProperty("原始数据ID")
    @Column(name = "raw_data_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '原始数据ID 对应表 kms_grab_response_data 的ID'")
    private String rawDataId;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 系统编码
     */
    @ApiModelProperty("系统编码")
    @TableField(value = "direct_code")
    @Column(name = "direct_code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '系统编码'")
    private String directCode;

    /**
     * 商超名称
     */
    @ApiModelProperty("系统名称")
    @TableField(value = "supermarket_name")
    @Column(name = "supermarket_name", length = 255, columnDefinition = "varchar(255) COMMENT '系统名称'")
    private String supermarketName;

    /**
     * 零售商编码
     */
    @ApiModelProperty("零售商编码")
    @Column(name = "ka_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '零售商编码'")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String kaCode;

    /**
     * 零售商名称
     */
    @ApiModelProperty("零售商名称")
    @Column(name = "ka_name", columnDefinition = "VARCHAR(255) COMMENT '零售商名称'")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String kaName;

    /**
     * 售达方名称
     */
    @ApiModelProperty("售达方名称")
    @TableField(value = "sold_to_party_name")
    @Column(name = "sold_to_party_name", length = 255, columnDefinition = "varchar(255) COMMENT '售达方名称'")
    private String soldToPartyName;

    /**
     * 售达方编码
     */
    @ApiModelProperty("售达方编码")
    @TableField(value = "sold_to_party_code")
    @Column(name = "sold_to_party_code", length = 64, columnDefinition = "varchar(64) COMMENT '售达方编码'")
    private String soldToPartyCode;

    /**
     * 费用单号
     */
    @ApiModelProperty("费用单号")
    @TableField(value = "invoice_expense_sheet_code")
    @Column(name = "invoice_expense_sheet_code", length = 64, columnDefinition = "varchar(64) COMMENT '费用单号'")
    private String invoiceExpenseSheetCode;

    /**
     * 费用单版本号
     */
    @ApiModelProperty("费用单版本号")
    @Column(name = "version_number", length = 10, columnDefinition = "INT(10) COMMENT '费用单版本号'")
    private Integer versionNumber;

    /**
     * 关联结算单号
     */
    @ApiModelProperty("关联结算单号")
    @TableField(value = "statement_code")
    @Column(name = "statement_code", length = 32, columnDefinition = "varchar(32) COMMENT '关联结算单号'")
    private String statementCode;

    /**
     * 送达方编码
     */
    @ApiModelProperty("送达方编码")
    @TableField(value = "delivery_party_code")
    @Column(name = "delivery_party_code", length = 32, columnDefinition = "varchar(32) COMMENT '送达方编码'")
    private String deliveryPartyCode;

    /**
     * 送达方名称
     */
    @ApiModelProperty("送达方名称")
    @TableField(value = "delivery_party_name")
    @Column(name = "delivery_party_name", length = 255, columnDefinition = "varchar(255) COMMENT '送达方名称'")
    private String deliveryPartyName;

    /**
     * 零售商门店编码
     */
    @ApiModelProperty("零售商门店编码")
    @TableField(value = "supermarket_store_code")
    @Column(name = "supermarket_store_code", length = 32, columnDefinition = "VARCHAR(64) COMMENT '零售商门店编码'")
    private String supermarketStoreCode;

    /**
     * 零售商门店名称
     */
    @ApiModelProperty("零售商门店名称")
    @TableField(value = "supermarket_store_name")
    @Column(name = "supermarket_store_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '零售商门店名称'")
    private String supermarketStoreName;

    @ApiModelProperty("零售商区域编码")
    @TableField(value = "area_code")
    @Column(name = "area_code", length = 64, columnDefinition = "varchar(64) COMMENT '零售商区域编码'")
    private String areaCode;

    @ApiModelProperty("零售商区域名称")
    @TableField(value = "area_name")
    @Column(name = "area_name", length = 256, columnDefinition = "varchar(256) COMMENT '零售商区域名称'")
    private String areaName;

    @ApiModelProperty("业务区域")
    @TableField(value = "business_area")
    @Column(name = "business_area", length = 64, columnDefinition = "varchar(64) COMMENT '业务区域'")
    private String businessArea;

    /**
     * 单据日期
     */
    @ApiModelProperty("单据日期")
    @TableField(value = "order_date")
    @Column(name = "order_date", length = 64, columnDefinition = "VARCHAR(64) COMMENT '单据日期'")
    private String orderDate;

    @ApiModelProperty("单据日期(页面用)")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @TableField(value = "order_time")
    @Column(name = "order_time" , length = 20, columnDefinition = "datetime COMMENT '单据日期(页面用)'")
    private Date orderTime;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @TableField(value = "product_code")
    @Column(name = "product_code", length = 64, columnDefinition = "varchar(32) COMMENT '产品编码'")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @TableField(value = "product_name")
    @Column(name = "product_name", length = 255, columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;


    /**
     * 零售商产品编码
     */
    @ApiModelProperty("零售商产品编码")
    @TableField(value = "ka_product_code")
    @Column(name = "ka_product_code", length = 64, columnDefinition = "varchar(32) COMMENT '零售商产品编码'")
    private String kaProductCode;

    /**
     * 零售商产品名称
     */
    @ApiModelProperty("零售商产品名称")
    @TableField(value = "ka_product_name")
    @Column(name = "ka_product_name", length = 255, columnDefinition = "varchar(255) COMMENT '零售商产品名称'")
    private String kaProductName;

    /**
     * 扣费明细项
     */
    @ApiModelProperty("扣费明细项编码")
    @TableField(value = "deduction_code")
    @Column(name = "deduction_code", length = 32, columnDefinition = "varchar(32) COMMENT '扣费明细项编码'")
    private String deductionCode;

    /**
     * 扣费明细项
     */
    @ApiModelProperty("扣费明细项名称")
    @TableField(value = "deduction_name")
    @Column(name = "deduction_name", length = 255, columnDefinition = "varchar(255) COMMENT '扣费明细项名称'")
    private String deductionName;

    /**
     * 扣费金额（含税）
     */
    @ApiModelProperty("扣费金额（含税）")
    @TableField(value = "amount")
    @Column(name = "amount",  columnDefinition = "decimal(24,6) COMMENT '扣费金额（含税）'")
    private BigDecimal amount;

    /**
     * 扣费金额（不含税）
     */
    @ApiModelProperty("扣费金额（不含税）")
    @TableField(value = "amount_not")
    @Column(name = "amount_not",  columnDefinition = "decimal(24,6) COMMENT '扣费金额（不含税）'")
    private BigDecimal amountNot;

    /**
     * 兑付方式
     */
    @ApiModelProperty("兑付方式")
    @TableField(value = "cashing_type")
    @Column(name = "cashing_type", length = 64, columnDefinition = "varchar(64) COMMENT '兑付方式'")
    private String cashingType;

    /**
     * 结案形式
     */
    @ApiModelProperty("结案形式")
    @TableField(value = "audit_way")
    @Column(name = "audit_way", length = 64, columnDefinition = "varchar(64) COMMENT '结案形式'")
    private String auditWay;

    /**
     * 单据来源
     */
    @ApiModelProperty("单据来源")
    @TableField(value = "invoices_source")
    @Column(name = "invoices_source", length = 64, columnDefinition = "varchar(64) COMMENT '单据来源'")
    private String invoicesSource;

    @ApiModelProperty("转换状态")
    @TableField(value = "order_status")
    @Column(name = "order_status", length = 32, columnDefinition = "varchar(32) COMMENT '转换状态'")
    private String orderStatus;

    @ApiModelProperty("转换状态描述")
    @TableField(value = "order_status_msg")
    @Column(name = "order_status_msg", length = 128, columnDefinition = "varchar(128) COMMENT '转换状态描述'")
    private String orderStatusMsg;

    @ApiModelProperty("登录账号")
    @TableField(value = "user_name")
    @Column(name = "user_name", length = 64, columnDefinition = "varchar(64) COMMENT '登录账号'")
    private String userName;

    /**
     * 省编码(门店管理-省)
     */
    @ApiModelProperty("省编码(门店管理-省)")
    @Column(name = "province_code", length = 32, columnDefinition = "varchar(32) COMMENT '省编码(门店管理-省)'")
    private String provinceCode;

    /**
     * 省名称(门店管理-省)
     */
    @ApiModelProperty("省名称(门店管理-省)")
    @Column(name = "province_name", length = 32, columnDefinition = "varchar(32) COMMENT '省名称(门店管理-省)'")
    private String provinceName;

    /**
     * 确认书（仅高鑫有）
     */
    @ApiModelProperty("确认书（仅高鑫有）")
    @Column(name = "query_code", length = 32, columnDefinition = "varchar(32) COMMENT '确认书（仅高鑫有）'")
    private String queryCode;
}
