package com.biz.crm.kms.business.invoice.expense.sheet.local.imports.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @Class InvoiceExpenseSheetImprotVo
 * @Description 单据-费用单导入模板
 * @Author : ZS
 * @Date: 2022/11/12  15:51
 */
@Data
@CrmExcelImport(startRow = 2)
public class InvoiceExpenseSheetImportsVo extends CrmExcelVo {

    /**
     * 系统编码
     */
    @CrmExcelColumn("*系统编码")
    private String directCode;

    /**
     * 商超名称
     */
    @CrmExcelColumn("*系统名称")
    private String supermarketName;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @CrmExcelColumn("*业态")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @CrmExcelColumn("*业务单元")
    private String businessUnitCode;

    /**
     *
     */
    @CrmExcelColumn("*售达方编码")
    private String soldToPartyCode;

    /**
     * 售达方名称
     */
    @CrmExcelColumn("*售达方名称")
    private String soldToPartyName;

    /**
     * 费用单号
     */
    @CrmExcelColumn("*费用单号")
    private String invoiceExpenseSheetCode;

    /**
     * 关联结算单号
     */
    @CrmExcelColumn("*关联零售商结算单编号")
    private String statementCode;

    /**
     * 送达方编码
     */
    @CrmExcelColumn("*送达方编码")
    private String deliveryPartyCode;

    /**
     * 送达方名称
     */
    @CrmExcelColumn("*送达方名称")
    private String deliveryPartyName;

    /**
     * 零售商门店编码
     */
    @CrmExcelColumn("*零售商门店编码")
    private String supermarketStoreCode;

    /**
     * 零售商门店名称
     */
    @CrmExcelColumn("*零售商门店名称")
    private String supermarketStoreName;

    /**
     * 零售商区域编码
     */
    @CrmExcelColumn("零售商区域编码")
    private String areaCode;

    /**
     * 零售商区域名称
     */
    @CrmExcelColumn("零售商区域名称")
    private String areaName;

    /**
     * 业务区域
     */
    @CrmExcelColumn("业务区域")
    private String businessArea;

    /**
     * 单据日期
     */
    @CrmExcelColumn("*单据日期")
    private String orderDate;

    /**
     * 产品编码
     */
    @CrmExcelColumn("*产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn("*产品名称")
    private String productName;

    /**
     * 产品名称
     */
    @CrmExcelColumn("*零售商产品编码")
    private String kaProductCode;

    /**
     * 零售商产品名称
     */
    @CrmExcelColumn("*零售商产品名称")
    private String kaProductName;

    /**
     * 扣费明细项编码
     */
    @CrmExcelColumn("*扣费明细项编码")
    private String deductionCode;

    /**
     * 扣费明细项名称
     */
    @CrmExcelColumn("*扣费明细项名称")
    private String deductionName;

    /**
     * 扣费金额(含税)
     */
    @CrmExcelColumn("*扣费金额(含税)")
    private String amountStr;

    /**
     * 扣费金额(不含税)
     */
    @CrmExcelColumn("*扣费金额(不含税)")
    private String amountNotStr;

    /**
     * 兑付方式
     */
    @CrmExcelColumn("*兑付方式")
    private String cashingType;

    /**
     * 结案形式
     */
    @CrmExcelColumn("*结案形式")
    private String auditWay;

}
