package com.biz.crm.kms.business.invoice.expense.sheet.local.imports.service;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.kms.business.invoice.expense.sheet.local.entity.InvoiceExpenseSheet;
import com.biz.crm.kms.business.invoice.expense.sheet.local.imports.model.InvoiceExpenseSheetImportsVo;
import com.biz.crm.kms.business.invoice.expense.sheet.local.service.InvoiceExpenseSheetImportsService;
import com.biz.crm.kms.business.invoice.expense.sheet.local.util.DictValueUtil;
import com.biz.crm.kms.business.invoice.sdk.constant.DirectConstant;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Class InvoiceStatementImportPre
 * @Description 单据-费用单导入服务层
 * @Author : ZS
 * @Date: 2022/11/12  11:19
 */
@Component
public class InvoiceExpenseSheetImportsProcess implements ImportProcess<InvoiceExpenseSheetImportsVo> {

    @Autowired
    private InvoiceExpenseSheetImportsService importSave;

    @Resource
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, InvoiceExpenseSheetImportsVo> data,
                                        TaskGlobalParamsVo paramsVo,
                                        Map<String, Object> params) {
        Validate.notEmpty(data, "导入数据不能为空！");

        List<InvoiceExpenseSheet> importList = this.validate(data);
        importSave.importsSave(importList);
        return null;
    }

    /**
     * 校验并转换数据
     **/
    private List<InvoiceExpenseSheet> validate(LinkedHashMap<Integer, InvoiceExpenseSheetImportsVo> data) {
        List<InvoiceExpenseSheetImportsVo> invoiceExpenseSheetImportsVos = new ArrayList<>(data.values());
        Set<String> codes = invoiceExpenseSheetImportsVos.stream().map(InvoiceExpenseSheetImportsVo::getInvoiceExpenseSheetCode).collect(Collectors.toSet());
        Validate.isTrue(Objects.equals(invoiceExpenseSheetImportsVos.size(),codes.size()),"费用单号有重复");
        List<InvoiceExpenseSheet> entities = new ArrayList<>();
        invoiceExpenseSheetImportsVos.forEach(importsVo -> {
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getInvoiceExpenseSheetCode()),"费用单号不能为空");
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getDirectCode()),"系统编码不能为空");
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getSupermarketName()),"系统名称不能为空");
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getBusinessFormatCode()),"业态不能为空");
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getBusinessUnitCode()),"业务单元不能为空");
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getSoldToPartyCode()),"售达方编码不能为空");
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getSoldToPartyName()),"售达方名称不能为空");
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getDeliveryPartyCode()),"送达方编码不能为空");
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getDeliveryPartyName()),"送达方名称不能为空");
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getSupermarketStoreCode()),"零售商门店编码不能为空");
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getSupermarketStoreName()),"零售商门店名称不能为空");
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getKaProductCode()),"零售商产品编码不能为空");
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getKaProductName()),"零售商产品名称不能为空");
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getProductCode()),"产品编码不能为空");
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getProductName()),"产品编码不能为空");
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getDeductionCode()),"扣费明细项编码不能为空");
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getDeductionName()),"扣费明细项名称不能为空");
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getAmountStr()),"扣费金额(含税)不能为空");
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getAmountNotStr()),"扣费金额(不含税)不能为空");
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getCashingType()),"兑付方式不能为空");
            Validate.isTrue(StringUtils.isNotBlank(importsVo.getAuditWay()),"结案形式不能为空");

            InvoiceExpenseSheet entity = this.nebulaToolkitService.copyObjectByWhiteList(importsVo,InvoiceExpenseSheet.class,HashSet.class,ArrayList.class);
            if (StringUtils.isNotBlank(importsVo.getAmountStr())){
                BigDecimal amount = new BigDecimal(importsVo.getAmountStr());
                entity.setAmount(amount);
            }
            if (StringUtils.isNotBlank(importsVo.getAmountNotStr())){
                BigDecimal amountNot = new BigDecimal(importsVo.getAmountNotStr());
                entity.setAmountNot(amountNot);
            }
            entities.add(entity);
        });
        if (CollectionUtils.isEmpty(entities)){
            return new ArrayList<>();
        }
        this.adjustData(entities);
        return entities;
    }
    //获取数据字典的值
    /**
     * 调整数据
     *
     * @param data 待调整数据
     * @return 调整后数据
     */
    private List<InvoiceExpenseSheet> adjustData(List<InvoiceExpenseSheet> data) {
        if (CollectionUtils.isEmpty(data)) {
            return new ArrayList<>();
        }
        Map<String, List<DictDataVo>> fomatMap = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(DirectConstant.MDM_BUSINESS_FORMAT));
        Map<String, List<DictDataVo>> unitMap = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(DirectConstant.MDM_BUSINESS_UNIT));
        for (InvoiceExpenseSheet entity :data)
        {
            entity.setBusinessFormatCode(DictValueUtil.findDictValue(fomatMap, DirectConstant.MDM_BUSINESS_FORMAT, entity.getBusinessFormatCode()));
            entity.setBusinessUnitCode(DictValueUtil.findDictValue(unitMap, DirectConstant.MDM_BUSINESS_UNIT, entity.getBusinessUnitCode()));

        }

        return data;
    }

    @Override
    public Class<InvoiceExpenseSheetImportsVo> findCrmExcelVoClass() {
        return InvoiceExpenseSheetImportsVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "KMS_INVOICE_EXPENSE_SHEET_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "KMS单据--费用单";
    }
}
