package com.biz.crm.kms.business.invoice.expense.sheet.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.kms.business.invoice.expense.sheet.local.entity.InvoiceExpenseSheet;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.invoice.expense.sheet.local.model.ExpenseSheetConditionModel;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * (InvoiceExpenseSheet)表mybatis访问层
 *
 * @author makejava
 * @since 2022-11-11 18:06:13
 */
public interface InvoiceExpenseSheetMapper extends BaseMapper<InvoiceExpenseSheet> {

    /**
    * @Description: 根据条件查询费用单
    * @Param: [dto]
    * @return: java.util.List<com.biz.crm.kms.business.invoice.expense.sheet.local.entity.InvoiceExpenseSheet>
    * @Author: ZS
    * @Date: 2022/11/16
    */
    List<InvoiceExpenseSheet> findExpenseSheet(@Param("dto") InvoiceExpenseSheetDto dto);


    /**
     * 多条件查询抓单规则列表
     *
     * @param model 条件model
     * @return 抓单规则列表
     */
    List<InvoiceExpenseSheet> findByReturnOrderConditionModel(@Param("model") ExpenseSheetConditionModel model);
    /**
     * @Description: 分页查询费用单
     * @Param: [page]
     * @Param: [dto]
     * @return: com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto>
     * @Author: heding
     * @Date: 2022/11/30
     */
    Page<InvoiceExpenseSheetDto> findExpenseSheetPaging(@Param("page") Page<InvoiceExpenseSheetDto> page,@Param("dto") InvoiceExpenseSheetDto dto);
}

