package com.biz.crm.kms.business.invoice.expense.sheet.local.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 费用单抓取数据多条件model
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ExpenseSheetGrabConditionModel", description = "费用单抓取数据多条件model")
public class ExpenseSheetGrabConditionModel {

  /**
   * 租户编号
   */
  @ApiModelProperty("租户编号")
  private String tenantCode;

  /**
   * 转换状态
   *
   * @see com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus
   */
  @ApiModelProperty("转换状态")
  private String orderStatus;

}
