package com.biz.crm.kms.business.invoice.expense.sheet.local.model;

import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductVo;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;
import java.util.Map;

/**
 * 费用单抓取数据解析model
 *
 * @author zs
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ExpenseSheetGrabSyncModel", description = "费用单抓取数据解析model")
public class ExpenseSheetGrabSyncModel {

  /**
   * 直营门店信息映射(key:系统编码+商超门店编码,value:直营门店信息)
   */
  @ApiModelProperty("直营门店信息映射(key:系统编码+商超门店编码,value:直营门店信息)")
  private Map<String, List<DirectStoreVo>> directStoreMap;

  /**
   * 终端供货关系映射(key:终端编码,value:终端供货关系信息)
   */
  @ApiModelProperty("终端供货关系映射(key:终端编码,value:终端供货关系信息)")
  private Map<String, List<TerminalSupplyVo>> terminalSupplyMap;

  /**
   * 直营商品信息映射(key:系统编码+商品编码,value:直营商品信息)
   */
  @ApiModelProperty("直营门店信息映射(key:系统编码+商品编码,value:直营商品信息)")
  private Map<String, List<DirectProductVo>> directProductMap;
}
