package com.biz.crm.kms.business.invoice.expense.sheet.local.repository;


import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.kms.business.invoice.expense.sheet.local.entity.InvoiceExpenseSheetGrab;
import com.biz.crm.kms.business.invoice.expense.sheet.local.mapper.InvoiceExpenseSheetGrabMapper;
import com.biz.crm.kms.business.invoice.expense.sheet.local.model.ExpenseSheetGrabConditionModel;
import com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * (InvoiceExpenseSheetGrab)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-18 14:45:20
 */
@Component
public class InvoiceExpenseSheetGrabRepository extends ServiceImpl<InvoiceExpenseSheetGrabMapper, InvoiceExpenseSheetGrab> {


    /**
     * 根据费用单单号集合获取待转换记录
     *
     * @return
     */
    public List<InvoiceExpenseSheetGrab> findByOrderNumbers(String tenantCode, List<String> orderNumbers) {
        return this.lambdaQuery()
                .eq(InvoiceExpenseSheetGrab::getTenantCode, tenantCode)
                .in(InvoiceExpenseSheetGrab::getInvoiceExpenseSheetCode, orderNumbers)
                .list();
    }

    /**
     * 费用单根据租户编码和转换状态查询费用单带商品
     *
     * @param pageable
     * @param tenantCode
     * @param transStatusList
     * @return
     */
    public Page<String> findExpenseSheetGrabPage(Pageable pageable, String tenantCode, List<String> transStatusList,String day) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        Page<String> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.baseMapper.findExpenseSheetGrabPage(page, tenantCode, transStatusList,day);
    }

    /**
     * 根据费用单号更新转换状态
     *
     * @param tenantCode  租户编码
     * @param transStatus 转换状态
     * @param orderNumberList 退货单号集合
     */
    public void updateTransStatusByOrderNumber(String tenantCode, GrabTransStatus transStatus, List<String> orderNumberList) {
        if (StringUtils.isBlank(tenantCode)
                || Objects.isNull(transStatus)
                || CollectionUtil.isEmpty(orderNumberList)) {
            return;
        }
        this.lambdaUpdate()
                .eq(InvoiceExpenseSheetGrab::getTenantCode, tenantCode)
                .in(InvoiceExpenseSheetGrab::getInvoiceExpenseSheetCode, orderNumberList)
                .set(InvoiceExpenseSheetGrab::getOrderStatus, transStatus.getDictCode())
                .update();
    }
}

