package com.biz.crm.kms.business.invoice.expense.sheet.local.service;


import com.biz.crm.kms.business.invoice.expense.sheet.local.entity.InvoiceExpenseSheet;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetGrabRuleDto;

import java.util.List;

/**
 * (InvoiceExpenseSheetGrab)表服务接口
 *
 * @author makejava
 * @since 2022-11-18 14:45:20
 */
public interface InvoiceExpenseSheetGrabService{
    /**
     * 根据单据号 转换单据信息
     *
     * @param orderNumberList 单据号
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022年12月15日 16:56:34
     */
    void manualSwitch(List<String> orderNumberList);

    /**
     * 费用单自动解析定时任务
     */
    void autoNotConvertExpenseSheet();
    /**
     * 费用单自动解析定时任务
     */
    void autoFailConvertExpenseSheet();


    /**
     * 费用单商超门店和商超产品转换
     *
     * @param entityList
     * @return void
     * @author: zs
     * @version: v1.0.0
     * @date: 2022年12月15日 15:15:06
     */
    void convertOrder(List<InvoiceExpenseSheet> entityList);

    /**
     * 过滤正在转换的费用单号
     *
     * @param orderNumberList 费用单号集合
     * @return void
     * @author: zs
     * @version: v1.0.0
     * @date: 2022年12月15日 15:15:01
     */
    void filterSwitchIngOrderNumberList(List<String> orderNumberList);
}

