package com.biz.crm.kms.business.invoice.expense.sheet.local.service.internal;

import com.biz.crm.kms.business.invoice.expense.sheet.local.service.InvoiceExpenseSheetGrabService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 费用单抓取数据(python)后自动转换     job
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.15 13:39
 */
@Slf4j
@Service
public class InvoiceExpenseSheetAutoJob {


    @Autowired(required = false)
    private InvoiceExpenseSheetGrabService invoiceExpenseSheetGrabService;


    /**
     * 费用单未转换单据自动转换定时任务
     */
    @DynamicTaskService(cornExpression = "0 0 1/2 * * ?", taskDesc = "费用单未转换单据自动转换定时任务")
    public void autoNotConvertAcceptanceOrder() {
        //TODO  需要改成  定时任务分片+redis锁
        invoiceExpenseSheetGrabService.autoNotConvertExpenseSheet();
    }


    /**
     * 费用单转换失败单据自动转换定时任务
     */
    @DynamicTaskService(cornExpression = "0 0 2/2 * * ?", taskDesc = "费用单转换失败单据自动转换定时任务")
    public void autoFailConvertAcceptanceOrder() {
        //TODO  需要改成  定时任务分片+redis锁
        invoiceExpenseSheetGrabService.autoFailConvertExpenseSheet();
    }

}
