package com.biz.crm.kms.business.invoice.expense.sheet.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.expense.sheet.local.entity.InvoiceExpenseSheet;
import com.biz.crm.kms.business.invoice.expense.sheet.local.service.InvoiceExpenseSheetImportsService;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetLogEventDto;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.event.InvoiceExpenseSheetLogEventListener;
import com.biz.crm.kms.business.invoice.sdk.enums.InvoicesStatus;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @Class InvoiceExpenseSheetImportsServiceImpl
 * @Description
 * @Author : ZS
 * @Date: 2022/11/12  16:15
 */
@Service
@Slf4j
public class InvoiceExpenseSheetImportsServiceImpl implements InvoiceExpenseSheetImportsService {


    @Autowired
    private InvoiceExpenseSheetServiceImpl invoiceExpenseSheetService;

    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    /**
     * 导入保存
     * @param list
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void importsSave(List<InvoiceExpenseSheet> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(aa ->{
            aa.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            aa.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            aa.setTenantCode(TenantUtils.getTenantCode());
            //数据来源说明
            aa.setInvoicesSource("手动导入");
            aa.setOrderStatus(InvoicesStatus.S200.getDictCode());
            this.invoiceExpenseSheetService.create(aa);
        });

        Collection<InvoiceExpenseSheetDto> invoiceStatementDtos = this.nebulaToolkitService.copyCollectionByWhiteList(list,InvoiceExpenseSheet.class,InvoiceExpenseSheetDto.class, LinkedHashSet.class, ArrayList.class);
        // 业务日志创建
        invoiceStatementDtos.forEach(dto -> {
            InvoiceExpenseSheetLogEventDto logEventDto = new InvoiceExpenseSheetLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer<InvoiceExpenseSheetLogEventListener, InvoiceExpenseSheetLogEventDto> onCreate =
                    InvoiceExpenseSheetLogEventListener::onCreate;
            this.nebulaNetEventClient.publish(logEventDto, InvoiceExpenseSheetLogEventListener.class, onCreate);
        });
    }
}
