package com.biz.crm.kms.business.invoice.expense.sheet.local.service.internal;


import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.expense.sheet.local.entity.InvoiceExpenseSheet;
import com.biz.crm.kms.business.invoice.expense.sheet.local.repository.InvoiceExpenseSheetRepository;
import com.biz.crm.kms.business.invoice.expense.sheet.local.service.InvoiceExpenseSheetService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * (InvoiceExpenseSheet)表服务实现类
 *
 * @author makejava
 * @since 2022-11-11 18:06:12
 */
@Service("invoiceExpenseSheetService")
public class InvoiceExpenseSheetServiceImpl implements InvoiceExpenseSheetService {

  @Autowired
  private InvoiceExpenseSheetRepository invoiceExpenseSheetRepository;

  
  /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public InvoiceExpenseSheet findById(String id) {
    if (StringUtils.isBlank(id)) {
	  return null;
	}
    return this.invoiceExpenseSheetRepository.getById(id);
  }
  
  /**
   * 新增数据
   * @param invoiceExpenseSheet 实体对象
   * @return 新增结果
   */
  @Transactional(rollbackFor = Exception.class)
  @Override
  public InvoiceExpenseSheet create(InvoiceExpenseSheet invoiceExpenseSheet) {
    this.createValidate(invoiceExpenseSheet);
    invoiceExpenseSheet.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    invoiceExpenseSheet.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    invoiceExpenseSheet.setTenantCode(TenantUtils.getTenantCode());
    this.invoiceExpenseSheetRepository.saveOrUpdate(invoiceExpenseSheet);
    return invoiceExpenseSheet;
  }
  
  /**
   * 修改新据
   * @param invoiceExpenseSheet 实体对象
   * @return 修改结果
   */
  @Transactional(rollbackFor = Exception.class)
  @Override
  public InvoiceExpenseSheet update(InvoiceExpenseSheet invoiceExpenseSheet) {
    this.updateValidate(invoiceExpenseSheet);
    this.invoiceExpenseSheetRepository.saveOrUpdate(invoiceExpenseSheet);
    return invoiceExpenseSheet;
  }
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  @Transactional(rollbackFor = Exception.class)
  @Override
  public void delete(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
    this.invoiceExpenseSheetRepository.removeByIds(idList);
  }
  
  /**
   * 启用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 启用结果
   */
  @Transactional(rollbackFor = Exception.class)
  @Override
  public void enable(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "启用数据时，主键集合不能为空！");
    this.invoiceExpenseSheetRepository.updateEnableStatusByIds(idList, EnableStatusEnum.ENABLE);
  }
  
  /**
   * 禁用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 禁用结果
   */
  @Transactional(rollbackFor = Exception.class)
  @Override
  public void disable(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "禁用数据时，主键集合不能为空！");
    this.invoiceExpenseSheetRepository.updateEnableStatusByIds(idList, EnableStatusEnum.DISABLE);
  }
  
  /**
   * 创建验证
   * @param invoiceExpenseSheet
   */
  private void createValidate(InvoiceExpenseSheet invoiceExpenseSheet) {
    Validate.notNull(invoiceExpenseSheet, "新增时，对象信息不能为空！");
    InvoiceExpenseSheet entity = this.invoiceExpenseSheetRepository.findByInvoiceExpenseSheetCode(TenantUtils.getTenantCode(),invoiceExpenseSheet.getInvoiceExpenseSheetCode());
    Validate.isTrue(ObjectUtils.isEmpty(entity),"已存在该费用单");
	invoiceExpenseSheet.setId(null);
     
  }
  
   /**
   * 修改验证
   * @param invoiceExpenseSheet
   */
  private void updateValidate(InvoiceExpenseSheet invoiceExpenseSheet) {
    Validate.notNull(invoiceExpenseSheet, "修改时，对象信息不能为空！");
      
  }
}

