package com.biz.crm.kms.business.invoice.expense.sheet.local.view;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @Class InvoiceExpenseSheet
 * @Description 单据-费用单
 * @Author : ZS
 * @Date: 2022/11/12  10:58
 */
@Component
public class InvoiceExpenseSheetDataViewRegister implements DataviewRegister {
    @Override
    public String code() {
        return "kms_invoice_expense_sheet_data_view";
    }

    @Override
    public String desc() {
        return "KMS单据-费用单";
    }

    @Override
    public String buildSql() {
        return "SELECT t.*, " +
                "DATE_FORMAT( t.create_time, '%Y-%m-%d %T' ) AS 'create_time_export', " +
                "DATE_FORMAT( t.modify_time, '%Y-%m-%d %T' ) AS 'modify_time_export', " +
                "kd.sales_org_code " +
                "FROM kms_invoice_expense_sheet t " +
                "LEFT JOIN kms_direct kd on t.direct_code = kd.direct_code " +
                "AND kd.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode() + "' " +
                "WHERE t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'" +
                "AND t.tenant_code = :tenandCode";
    }
}
