/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.expense.sheet.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.invoice.expense.sheet.local.service.InvoiceExpenseSheetGrabService;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.service.InvoiceExpenseSheetVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5355\u636e--\u8d39\u7528\u5355Vo\u63a7\u5236\u5c42"})
@RequestMapping(value={"/v1/invoiceExpenseSheetVo/invoiceExpenseSheetVo"})
public class InvoiceExpenseSheetVoController {
    private static final Logger log = LoggerFactory.getLogger(InvoiceExpenseSheetVoController.class);
    @Autowired
    private InvoiceExpenseSheetVoService invoiceExpenseSheetVoService;
    @Autowired
    private InvoiceExpenseSheetGrabService service;

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u8d39\u7528\u5355")
    @GetMapping(value={"/findExpenseSheet"})
    public Result<List<InvoiceExpenseSheetDto>> findExpenseSheet(@RequestParam InvoiceExpenseSheetDto dto) {
        try {
            List invoiceExpenseSheetDtoList = this.invoiceExpenseSheetVoService.findExpenseSheet(dto);
            return Result.ok((Object)invoiceExpenseSheetDtoList);
        }
        catch (RuntimeException e) {
            log.info(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8d39\u7528\u5355\u624b\u52a8\u8f6c\u6362")
    @PatchMapping(value={"/manualSwitch"})
    public Result<?> manualSwitch(@RequestBody List<String> ids) {
        try {
            this.invoiceExpenseSheetVoService.manualSwitch(ids);
            return Result.ok((String)"\u8f6c\u6362\u7ed3\u675f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8d39\u7528\u5355")
    @GetMapping(value={"/findExpenseSheetPaging"})
    public Result<Page<InvoiceExpenseSheetDto>> findExpenseSheetPaging(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @RequestBody(required=false) InvoiceExpenseSheetDto dto) {
        try {
            Page page = this.invoiceExpenseSheetVoService.findExpenseSheetPaging(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (RuntimeException e) {
            log.info(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u89e6\u53d1\u5b9a\u65f6\u4efb\u52a1")
    @GetMapping(value={"autoJob"})
    public void autoJob() {
        this.service.autoNotConvertExpenseSheet();
    }
}

