/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.expense.sheet.local.imports.service;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.kms.business.invoice.expense.sheet.local.entity.InvoiceExpenseSheet;
import com.biz.crm.kms.business.invoice.expense.sheet.local.imports.model.InvoiceExpenseSheetImportsVo;
import com.biz.crm.kms.business.invoice.expense.sheet.local.service.InvoiceExpenseSheetImportsService;
import com.biz.crm.kms.business.invoice.expense.sheet.local.util.DictValueUtil;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class InvoiceExpenseSheetImportsProcess
implements ImportProcess<InvoiceExpenseSheetImportsVo> {
    @Autowired
    private InvoiceExpenseSheetImportsService importSave;
    @Resource
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public Map<Integer, String> execute(LinkedHashMap<Integer, InvoiceExpenseSheetImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<InvoiceExpenseSheet> importList = this.validate(data);
        this.importSave.importsSave(importList);
        return null;
    }

    private List<InvoiceExpenseSheet> validate(LinkedHashMap<Integer, InvoiceExpenseSheetImportsVo> data) {
        ArrayList<InvoiceExpenseSheetImportsVo> invoiceExpenseSheetImportsVos = new ArrayList<InvoiceExpenseSheetImportsVo>(data.values());
        Set codes = invoiceExpenseSheetImportsVos.stream().map(InvoiceExpenseSheetImportsVo::getInvoiceExpenseSheetCode).collect(Collectors.toSet());
        Validate.isTrue((boolean)Objects.equals(invoiceExpenseSheetImportsVos.size(), codes.size()), (String)"\u8d39\u7528\u5355\u53f7\u6709\u91cd\u590d", (Object[])new Object[0]);
        ArrayList<InvoiceExpenseSheet> entities = new ArrayList<InvoiceExpenseSheet>();
        invoiceExpenseSheetImportsVos.forEach(importsVo -> {
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getInvoiceExpenseSheetCode()), (String)"\u8d39\u7528\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getDirectCode()), (String)"\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getSupermarketName()), (String)"\u7cfb\u7edf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getBusinessFormatCode()), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getBusinessUnitCode()), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getSoldToPartyCode()), (String)"\u552e\u8fbe\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getSoldToPartyName()), (String)"\u552e\u8fbe\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getDeliveryPartyCode()), (String)"\u9001\u8fbe\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getDeliveryPartyName()), (String)"\u9001\u8fbe\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getSupermarketStoreCode()), (String)"\u96f6\u552e\u5546\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getSupermarketStoreName()), (String)"\u96f6\u552e\u5546\u95e8\u5e97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getKaProductCode()), (String)"\u96f6\u552e\u5546\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getKaProductName()), (String)"\u96f6\u552e\u5546\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getProductCode()), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getProductName()), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getDeductionCode()), (String)"\u6263\u8d39\u660e\u7ec6\u9879\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getDeductionName()), (String)"\u6263\u8d39\u660e\u7ec6\u9879\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getAmountStr()), (String)"\u6263\u8d39\u91d1\u989d(\u542b\u7a0e)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getAmountNotStr()), (String)"\u6263\u8d39\u91d1\u989d(\u4e0d\u542b\u7a0e)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getCashingType()), (String)"\u5151\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)importsVo.getAuditWay()), (String)"\u7ed3\u6848\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            InvoiceExpenseSheet entity = (InvoiceExpenseSheet)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)importsVo, InvoiceExpenseSheet.class, HashSet.class, ArrayList.class, new String[0])));
            if (StringUtils.isNotBlank((CharSequence)importsVo.getAmountStr())) {
                BigDecimal amount = new BigDecimal(importsVo.getAmountStr());
                entity.setAmount(amount);
            }
            if (StringUtils.isNotBlank((CharSequence)importsVo.getAmountNotStr())) {
                BigDecimal amountNot = new BigDecimal(importsVo.getAmountNotStr());
                entity.setAmountNot(amountNot);
            }
            entities.add(entity);
        });
        if (CollectionUtils.isEmpty(entities)) {
            return new ArrayList<InvoiceExpenseSheet>();
        }
        this.adjustData(entities);
        return entities;
    }

    private List<InvoiceExpenseSheet> adjustData(List<InvoiceExpenseSheet> data) {
        if (CollectionUtils.isEmpty(data)) {
            return new ArrayList<InvoiceExpenseSheet>();
        }
        Map fomatMap = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"mdm_business_format"}));
        Map unitMap = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"mdm_business_unit"}));
        for (InvoiceExpenseSheet entity : data) {
            entity.setBusinessFormatCode(DictValueUtil.findDictValue(fomatMap, "mdm_business_format", entity.getBusinessFormatCode()));
            entity.setBusinessUnitCode(DictValueUtil.findDictValue(unitMap, "mdm_business_unit", entity.getBusinessUnitCode()));
        }
        return data;
    }

    public Class<InvoiceExpenseSheetImportsVo> findCrmExcelVoClass() {
        return InvoiceExpenseSheetImportsVo.class;
    }

    public String getTemplateCode() {
        return "KMS_INVOICE_EXPENSE_SHEET_IMPORT";
    }

    public String getTemplateName() {
        return "KMS\u5355\u636e--\u8d39\u7528\u5355";
    }
}

