/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.expense.sheet.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.kms.business.invoice.expense.sheet.local.entity.InvoiceExpenseSheetGrab;
import com.biz.crm.kms.business.invoice.expense.sheet.local.mapper.InvoiceExpenseSheetGrabMapper;
import com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class InvoiceExpenseSheetGrabRepository
extends ServiceImpl<InvoiceExpenseSheetGrabMapper, InvoiceExpenseSheetGrab> {
    public List<InvoiceExpenseSheetGrab> findByOrderNumbers(String tenantCode, List<String> orderNumbers) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(InvoiceExpenseSheetGrab::getInvoiceExpenseSheetCode, orderNumbers)).list();
    }

    public Page<String> findExpenseSheetGrabPage(Pageable pageable, String tenantCode, List<String> transStatusList, String day) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((InvoiceExpenseSheetGrabMapper)this.baseMapper).findExpenseSheetGrabPage((Page<String>)page, tenantCode, transStatusList, day);
    }

    public void updateTransStatusByOrderNumber(String tenantCode, GrabTransStatus transStatus, List<String> orderNumberList) {
        if (StringUtils.isBlank((CharSequence)tenantCode) || Objects.isNull(transStatus) || CollectionUtil.isEmpty(orderNumberList)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(InvoiceExpenseSheetGrab::getInvoiceExpenseSheetCode, orderNumberList)).set(InvoiceExpenseSheetGrab::getOrderStatus, (Object)transStatus.getDictCode())).update();
    }
}

