/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.expense.sheet.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.expense.sheet.local.entity.InvoiceExpenseSheet;
import com.biz.crm.kms.business.invoice.expense.sheet.local.mapper.InvoiceExpenseSheetMapper;
import com.biz.crm.kms.business.invoice.expense.sheet.local.model.ExpenseSheetConditionModel;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class InvoiceExpenseSheetRepository
extends ServiceImpl<InvoiceExpenseSheetMapper, InvoiceExpenseSheet> {
    public List<InvoiceExpenseSheet> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enableStatus.getCode())).update();
    }

    public List<InvoiceExpenseSheet> findExpenseSheet(InvoiceExpenseSheetDto dto) {
        return ((InvoiceExpenseSheetMapper)this.baseMapper).findExpenseSheet(dto);
    }

    public List<InvoiceExpenseSheet> findByOrderNumberList(String tenantCode, List<String> orderNumberList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(InvoiceExpenseSheet::getInvoiceExpenseSheetCode, orderNumberList)).list();
    }

    public List<InvoiceExpenseSheet> findByReturnOrderConditionModel(ExpenseSheetConditionModel model) {
        return ((InvoiceExpenseSheetMapper)this.baseMapper).findByReturnOrderConditionModel(model);
    }

    public Page<InvoiceExpenseSheetDto> findExpenseSheetPaging(Pageable pageable, InvoiceExpenseSheetDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<InvoiceExpenseSheetDto> pageList = ((InvoiceExpenseSheetMapper)this.baseMapper).findExpenseSheetPaging((Page<InvoiceExpenseSheetDto>)page, dto);
        return pageList;
    }

    public InvoiceExpenseSheet findByInvoiceExpenseSheetCode(String tenantCode, String code) {
        return (InvoiceExpenseSheet)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(InvoiceExpenseSheet::getInvoiceExpenseSheetCode, (Object)code)).one());
    }

    public void cancel(String statementCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(InvoiceExpenseSheet::getStatementCode, (Object)statementCode)).set(InvoiceExpenseSheet::getStatementCode, null)).update();
    }

    public void match(List<String> orderNumbers, String statementCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(InvoiceExpenseSheet::getInvoiceExpenseSheetCode, orderNumbers)).set(InvoiceExpenseSheet::getStatementCode, (Object)statementCode)).update();
    }

    public List<InvoiceExpenseSheet> syncExpense(List<String> directCodes) {
        if (CollectionUtils.isEmpty(directCodes)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(!CollectionUtils.isEmpty(directCodes), InvoiceExpenseSheet::getDirectCode, directCodes)).isNull(InvoiceExpenseSheet::getAmount)).list();
    }

    public List<InvoiceExpenseSheet> findByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return new ArrayList<InvoiceExpenseSheet>();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(!CollectionUtils.isEmpty(codes), InvoiceExpenseSheet::getInvoiceExpenseSheetCode, codes)).list();
    }
}

