/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.expense.sheet.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductVo;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.kms.business.invoice.expense.sheet.local.entity.InvoiceExpenseSheet;
import com.biz.crm.kms.business.invoice.expense.sheet.local.repository.InvoiceExpenseSheetGrabRepository;
import com.biz.crm.kms.business.invoice.expense.sheet.local.repository.InvoiceExpenseSheetRepository;
import com.biz.crm.kms.business.invoice.expense.sheet.local.service.InvoiceExpenseSheetGrabsThreadService;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.enums.ExpenseSheetStatus;
import com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus;
import com.biz.crm.kms.business.invoice.sdk.enums.InvoicesStatus;
import com.biz.crm.mn.common.base.service.RedisCrmService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class InvoiceExpenseSheetGrabsThreadServiceImpl
implements InvoiceExpenseSheetGrabsThreadService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceExpenseSheetGrabsThreadServiceImpl.class);
    @Autowired
    private InvoiceExpenseSheetRepository invoiceExpenseSheetRepository;
    @Autowired
    private InvoiceExpenseSheetGrabRepository invoiceExpenseSheetGrabRepository;
    @Autowired
    private RedisCrmService redisCrmService;
    @Autowired(required=false)
    private RedisTemplate redisTemplate;

    @Override
    @Async(value="grabThread")
    @Transactional(propagation=Propagation.NOT_SUPPORTED, rollbackFor={Exception.class})
    public void saveExpenseSheetData(List<InvoiceExpenseSheet> entityList, Map<String, List<DirectVo>> directMap, Map<String, List<DirectStoreVo>> directStoreMap, Map<String, List<DirectProductVo>> directProductMap) {
        log.info("--  \u8fdb\u5165\u7ebf\u7a0b\u6c60\u5b58\u50a8\u6570\u636e  --");
        List orderNumbers = entityList.stream().map(InvoiceExpenseSheet::getInvoiceExpenseSheetCode).collect(Collectors.toList());
        HashSet orderNumberSet = new HashSet();
        HashSet orderNumberSuccessSet = new HashSet();
        Map map = this.redisTemplate.hasKey((Object)"KMS:CACHE:PRODUCT_TAX_RATE") != false ? (Map)this.redisTemplate.opsForValue().get((Object)"KMS:CACHE:PRODUCT_TAX_RATE") : null;
        entityList.forEach(entity -> {
            try {
                this.redisCrmService.hdel("KMS:EXPENSE_SHEET:CONVERT:LOCK", new Object[]{entity.getInvoiceExpenseSheetCode()});
                this.clearTransformInfoOne((InvoiceExpenseSheet)((Object)entity), directMap);
                if (StringUtils.isNotBlank((CharSequence)entity.getSupermarketStoreCode())) {
                    String deliveryCode = this.buildOrderInfoTwo((InvoiceExpenseSheet)((Object)entity), directStoreMap);
                    if (StringUtils.isNotBlank((CharSequence)entity.getKaProductCode())) {
                        this.convertAcceptanceOrderItemThree((InvoiceExpenseSheet)((Object)entity), directProductMap, map, deliveryCode);
                    }
                } else {
                    entity.setOrderStatusMsg(null);
                    entity.setOrderStatus(InvoicesStatus.S200.getDictCode());
                }
                this.setOrderStatusAndMsgFour((InvoiceExpenseSheet)((Object)entity));
                this.invoiceExpenseSheetRepository.saveOrUpdate(entity);
                if (Objects.equals(InvoicesStatus.S200.getDictCode(), entity.getOrderStatus())) {
                    orderNumberSuccessSet.add(entity.getInvoiceExpenseSheetCode());
                } else {
                    orderNumberSet.add(entity.getInvoiceExpenseSheetCode());
                }
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u8d39\u7528\u5355\u6570\u636e\u5931\u8d25", (Throwable)e);
                entity.setOrderStatus(InvoicesStatus.S100.getDictCode());
                entity.setOrderStatusMsg("\u8f6c\u6362\u65f6\u5f02\u5e38!");
                try {
                    this.invoiceExpenseSheetRepository.saveOrUpdate(entity);
                    orderNumberSet.add(entity.getInvoiceExpenseSheetCode());
                }
                catch (Exception ex) {
                    log.error("", (Throwable)ex);
                }
            }
        });
        if (CollectionUtil.isEmpty(orderNumberSet) && CollectionUtils.isEmpty(orderNumberSuccessSet)) {
            return;
        }
        this.redisCrmService.hdel("KMS:EXPENSE_SHEET:CONVERT:LOCK", new Object[]{orderNumbers});
        try {
            if (!CollectionUtils.isEmpty(orderNumberSet)) {
                this.invoiceExpenseSheetGrabRepository.updateTransStatusByOrderNumber(TenantUtils.getTenantCode(), GrabTransStatus.TRANS_FAIL, new ArrayList<String>(orderNumberSet));
            }
            if (!CollectionUtils.isEmpty(orderNumberSuccessSet)) {
                this.invoiceExpenseSheetGrabRepository.updateTransStatusByOrderNumber(TenantUtils.getTenantCode(), GrabTransStatus.HAVE_TRANS, new ArrayList<String>(orderNumberSuccessSet));
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public void clearTransformInfoOne(InvoiceExpenseSheet entity, Map<String, List<DirectVo>> directMap) {
        List<DirectVo> directVos;
        entity.setDeliveryPartyCode(null);
        entity.setDeliveryPartyName(null);
        entity.setAreaName(null);
        entity.setAreaCode(null);
        if (StringUtils.isNotBlank((CharSequence)entity.getOrderDate())) {
            try {
                entity.setOrderTime(new SimpleDateFormat("yyyy-MM-dd").parse(entity.getOrderDate()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (CollectionUtils.isEmpty(directVos = directMap.get(entity.getDirectCode()))) {
            entity.setOrderStatusMsg("\u4e0d\u5b58\u5728\u8be5\u7cfb\u7edf");
        } else {
            DirectVo directVo = directVos.get(0);
            entity.setBusinessFormatCode(directVo.getBusinessFormatCode());
            entity.setBusinessUnitCode(directVo.getBusinessUnitCode());
        }
    }

    public String buildOrderInfoTwo(InvoiceExpenseSheet entity, Map<String, List<DirectStoreVo>> directStoreMap) {
        entity.setOrderStatus(ExpenseSheetStatus.S100.getDictCode());
        entity.setSoldToPartyName(null);
        entity.setSoldToPartyCode(null);
        if (StringUtils.isBlank((CharSequence)entity.getDirectCode())) {
            entity.setOrderStatusMsg("\u7cfb\u7edf\u7f16\u7801\u4e3a\u7a7a");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)entity.getSupermarketStoreCode())) {
            entity.setOrderStatusMsg("\u5355\u636e\u5546\u8d85\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a");
            return null;
        }
        List<DirectStoreVo> directStoreList = directStoreMap.get(entity.getDirectCode() + "_" + entity.getSupermarketStoreCode());
        DirectStoreVo directStoreVo = null;
        if (CollectionUtil.isEmpty(directStoreList)) {
            entity.setOrderStatusMsg("\u672a\u67e5\u8be2\u5230\u4e0e\u4f01\u4e1a\u95e8\u5e97\u5bf9\u5e94\u5173\u7cfb");
            return null;
        }
        if (directStoreList.size() > 1) {
            entity.setOrderStatusMsg("\u5546\u8d85\u95e8\u5e97\u4e0e\u4f01\u4e1a\u95e8\u5e97\u5bf9\u5e94\u5173\u7cfb\u5b58\u5728[" + directStoreList.size() + "]\u6761");
            return null;
        }
        directStoreVo = directStoreList.get(0);
        entity.setSupermarketStoreCode(directStoreVo.getSupermarketStoreCode());
        if (StringUtils.isEmpty((CharSequence)entity.getSupermarketStoreName())) {
            entity.setSupermarketStoreName(directStoreVo.getSupermarketStoreName());
        }
        entity.setSoldToPartyCode(directStoreVo.getSoldToPartyCode());
        entity.setSoldToPartyName(directStoreVo.getSoldToPartyName());
        entity.setDeliveryPartyCode(directStoreVo.getTerminalCode());
        entity.setDeliveryPartyName(directStoreVo.getTerminalName());
        entity.setAreaName(directStoreVo.getRetailerRegion());
        entity.setBusinessArea(directStoreVo.getBusinessArea());
        entity.setProvinceCode(directStoreVo.getProvinceCode());
        entity.setProvinceName(directStoreVo.getProvinceName());
        entity.setOrderStatus(ExpenseSheetStatus.S200.getDictCode());
        return directStoreVo.getRetailerTerminalCode();
    }

    private void convertAcceptanceOrderItemThree(InvoiceExpenseSheet entity, Map<String, List<DirectProductVo>> directProductMap, Map<String, BigDecimal> map, String deliveryCode) {
        List<DirectProductVo> productVos;
        entity.setOrderStatus(ExpenseSheetStatus.S100.getDictCode());
        if (StringUtils.isBlank((CharSequence)entity.getKaProductCode())) {
            entity.setOrderStatusMsg("\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a");
            return;
        }
        DirectProductVo productVo = null;
        List<Object> productVoList = new ArrayList<DirectProductVo>();
        List<DirectProductVo> productVoLists = directProductMap.get(entity.getDirectCode() + "_" + entity.getDeliveryPartyCode() + "_" + entity.getKaProductCode());
        if (CollectionUtil.isNotEmpty(productVoLists)) {
            productVoList.addAll(productVoLists);
        }
        if (CollectionUtil.isEmpty(productVoList) && StringUtils.isNotBlank((CharSequence)deliveryCode) && CollectionUtil.isNotEmpty(productVos = directProductMap.get(entity.getDirectCode() + "_" + deliveryCode + "_" + entity.getKaProductCode()))) {
            productVoList.addAll(productVos);
        }
        if (CollectionUtil.isEmpty(productVoList)) {
            entity.setOrderStatusMsg("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb");
        } else if (productVoList.size() == 1) {
            productVo = (DirectProductVo)productVoList.get(0);
        } else {
            int allSize = productVoList.size();
            if (CollectionUtil.isEmpty(productVoList = productVoList.stream().filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getIsDefault())).collect(Collectors.toList()))) {
                entity.setOrderStatusMsg("\u5171[" + allSize + "]\u6761\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb,\u65e0\u9ed8\u8ba4\u5bf9\u5e94\u5173\u7cfb");
            } else if (productVoList.size() > 1) {
                entity.setOrderStatusMsg("[" + productVoList.size() + "]\u6761\u9ed8\u8ba4\u5546\u54c1\u5bf9\u5e94\u5173\u7cfb");
            } else {
                productVo = (DirectProductVo)productVoList.get(0);
            }
        }
        if (Objects.isNull(productVo)) {
            return;
        }
        entity.setProductCode(productVo.getProductCode());
        entity.setProductName(productVo.getProductName());
        entity = this.setAccount(entity, map);
        entity.setOrderStatus(ExpenseSheetStatus.S200.getDictCode());
    }

    private InvoiceExpenseSheet setAccount(InvoiceExpenseSheet entity, Map<String, BigDecimal> map) {
        String goodsCode = entity.getProductCode();
        if (!StringUtils.isEmpty((CharSequence)goodsCode)) {
            if (Objects.isNull(map)) {
                return entity;
            }
            BigDecimal bigDecimal = map.get(goodsCode);
            if (Objects.isNull(bigDecimal)) {
                return entity;
            }
            if (Objects.nonNull(entity.getAmount()) && Objects.isNull(entity.getAmountNot())) {
                entity.setAmountNot(entity.getAmount().divide(BigDecimal.ONE.add(bigDecimal), 4, 4));
            }
            if (Objects.nonNull(entity.getAmountNot()) && Objects.isNull(entity.getAmount())) {
                entity.setAmount(entity.getAmountNot().multiply(BigDecimal.ONE.add(bigDecimal)).setScale(4, 4));
            }
        }
        return entity;
    }

    public void setOrderStatusAndMsgFour(InvoiceExpenseSheet entity) {
        if (Objects.equals(entity.getOrderStatus(), ExpenseSheetStatus.S200.getDictCode())) {
            entity.setOrderStatusMsg("\u8f6c\u6362\u6210\u529f");
        }
    }
}

