/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.expense.sheet.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.expense.sheet.local.entity.InvoiceExpenseSheet;
import com.biz.crm.kms.business.invoice.expense.sheet.local.service.InvoiceExpenseSheetImportsService;
import com.biz.crm.kms.business.invoice.expense.sheet.local.service.internal.InvoiceExpenseSheetServiceImpl;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetLogEventDto;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.event.InvoiceExpenseSheetLogEventListener;
import com.biz.crm.kms.business.invoice.sdk.enums.InvoicesStatus;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class InvoiceExpenseSheetImportsServiceImpl
implements InvoiceExpenseSheetImportsService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceExpenseSheetImportsServiceImpl.class);
    @Autowired
    private InvoiceExpenseSheetServiceImpl invoiceExpenseSheetService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importsSave(List<InvoiceExpenseSheet> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(aa -> {
            aa.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            aa.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            aa.setTenantCode(TenantUtils.getTenantCode());
            aa.setInvoicesSource("\u624b\u52a8\u5bfc\u5165");
            aa.setOrderStatus(InvoicesStatus.S200.getDictCode());
            this.invoiceExpenseSheetService.create((InvoiceExpenseSheet)((Object)aa));
        });
        Collection invoiceStatementDtos = this.nebulaToolkitService.copyCollectionByWhiteList(list, InvoiceExpenseSheet.class, InvoiceExpenseSheetDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        invoiceStatementDtos.forEach(dto -> {
            InvoiceExpenseSheetLogEventDto logEventDto = new InvoiceExpenseSheetLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = InvoiceExpenseSheetLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, InvoiceExpenseSheetLogEventListener.class, (SerializableBiConsumer)onCreate);
        });
    }
}

