/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.expense.sheet.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.expense.sheet.local.entity.InvoiceExpenseSheet;
import com.biz.crm.kms.business.invoice.expense.sheet.local.repository.InvoiceExpenseSheetRepository;
import com.biz.crm.kms.business.invoice.expense.sheet.local.service.InvoiceExpenseSheetService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service(value="invoiceExpenseSheetService")
public class InvoiceExpenseSheetServiceImpl
implements InvoiceExpenseSheetService {
    @Autowired
    private InvoiceExpenseSheetRepository invoiceExpenseSheetRepository;

    @Override
    public InvoiceExpenseSheet findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (InvoiceExpenseSheet)((Object)this.invoiceExpenseSheetRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public InvoiceExpenseSheet create(InvoiceExpenseSheet invoiceExpenseSheet) {
        this.createValidate(invoiceExpenseSheet);
        invoiceExpenseSheet.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        invoiceExpenseSheet.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        invoiceExpenseSheet.setTenantCode(TenantUtils.getTenantCode());
        this.invoiceExpenseSheetRepository.saveOrUpdate((Object)invoiceExpenseSheet);
        return invoiceExpenseSheet;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public InvoiceExpenseSheet update(InvoiceExpenseSheet invoiceExpenseSheet) {
        this.updateValidate(invoiceExpenseSheet);
        this.invoiceExpenseSheetRepository.saveOrUpdate((Object)invoiceExpenseSheet);
        return invoiceExpenseSheet;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.invoiceExpenseSheetRepository.removeByIds(idList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.invoiceExpenseSheetRepository.updateEnableStatusByIds(idList, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.invoiceExpenseSheetRepository.updateEnableStatusByIds(idList, EnableStatusEnum.DISABLE);
    }

    private void createValidate(InvoiceExpenseSheet invoiceExpenseSheet) {
        Validate.notNull((Object)((Object)invoiceExpenseSheet), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        InvoiceExpenseSheet entity = this.invoiceExpenseSheetRepository.findByInvoiceExpenseSheetCode(TenantUtils.getTenantCode(), invoiceExpenseSheet.getInvoiceExpenseSheetCode());
        Validate.isTrue((boolean)ObjectUtils.isEmpty((Object)((Object)entity)), (String)"\u5df2\u5b58\u5728\u8be5\u8d39\u7528\u5355", (Object[])new Object[0]);
        invoiceExpenseSheet.setId(null);
    }

    private void updateValidate(InvoiceExpenseSheet invoiceExpenseSheet) {
        Validate.notNull((Object)((Object)invoiceExpenseSheet), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

