/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.expense.sheet.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.invoice.expense.sheet.local.entity.InvoiceExpenseSheet;
import com.biz.crm.kms.business.invoice.expense.sheet.local.repository.InvoiceExpenseSheetRepository;
import com.biz.crm.kms.business.invoice.expense.sheet.local.service.InvoiceExpenseSheetGrabService;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.service.InvoiceExpenseSheetVoService;
import com.biz.crm.kms.business.invoice.sdk.enums.InvoicesStatus;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InvoiceExpenseSheetVoServiceImpl
implements InvoiceExpenseSheetVoService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceExpenseSheetVoServiceImpl.class);
    @Autowired
    private InvoiceExpenseSheetRepository invoiceExpenseSheetRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private InvoiceExpenseSheetGrabService invoiceExpenseSheetGrabService;

    public List<InvoiceExpenseSheetDto> findExpenseSheet(InvoiceExpenseSheetDto invoiceExpenseSheetDto) {
        List<InvoiceExpenseSheet> expenseSheets = this.invoiceExpenseSheetRepository.findExpenseSheet(invoiceExpenseSheetDto);
        List expenseSheetDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(expenseSheets, InvoiceExpenseSheet.class, InvoiceExpenseSheetDto.class, HashSet.class, ArrayList.class, new String[0]);
        return expenseSheetDtos;
    }

    public Page<InvoiceExpenseSheetDto> findExpenseSheetPaging(Pageable pageable, InvoiceExpenseSheetDto dto) {
        if (Objects.isNull(dto)) {
            dto = new InvoiceExpenseSheetDto();
        }
        return this.invoiceExpenseSheetRepository.findExpenseSheetPaging(pageable, dto);
    }

    public void manualSwitch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<InvoiceExpenseSheet> entities = this.invoiceExpenseSheetRepository.findByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(entities) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5", (Object[])new Object[0]);
        Validate.isTrue((!ObjectUtils.notEqual((Object)entities.size(), (Object)ids.size()) ? 1 : 0) != 0, (String)"\u6570\u636e\u8f6c\u6362\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        entities.forEach(entity -> Validate.isTrue((boolean)Lists.newArrayList((Object[])new String[]{InvoicesStatus.S200.getDictCode(), InvoicesStatus.S101.getDictCode(), InvoicesStatus.S100.getDictCode()}).contains(entity.getOrderStatus()), (String)String.format("\u9a8c\u6536\u5355[%s]\u5df2\u786e\u8ba4,\u65e0\u6cd5\u7ee7\u7eed\u5339\u914d", entity.getInvoiceExpenseSheetCode()), (Object[])new Object[0]));
        List<String> orderNumbers = entities.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getInvoiceExpenseSheetCode())).map(InvoiceExpenseSheet::getInvoiceExpenseSheetCode).distinct().collect(Collectors.toList());
        this.invoiceExpenseSheetGrabService.filterSwitchIngOrderNumberList(orderNumbers);
        log.info("===== \u8d39\u7528\u5355\u624b\u52a8\u8f6c\u6362\u5f00\u59cb ======");
        this.invoiceExpenseSheetGrabService.manualSwitch(orderNumbers);
        log.info("===== \u8d39\u7528\u5355\u624b\u52a8\u8f6c\u6362\u5b8c\u6210 ======");
    }

    public void match(List<String> orderNumbers, String statementCode) {
        Validate.isTrue((!CollectionUtils.isEmpty(orderNumbers) && StringUtils.isNotBlank((CharSequence)statementCode) ? 1 : 0) != 0, (String)"\u9a8c\u6536\u5355\u53f7\u548c\u7ed3\u7b97\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.invoiceExpenseSheetRepository.cancel(statementCode);
        this.invoiceExpenseSheetRepository.match(orderNumbers, statementCode);
    }

    public List<String> syncExpense(List<String> directCodes) {
        List<InvoiceExpenseSheet> invoiceExpenseSheets = this.invoiceExpenseSheetRepository.syncExpense(directCodes);
        if (CollectionUtils.isEmpty(invoiceExpenseSheets)) {
            return new ArrayList<String>();
        }
        List<String> expenseCodes = invoiceExpenseSheets.stream().map(InvoiceExpenseSheet::getInvoiceExpenseSheetCode).collect(Collectors.toList());
        return expenseCodes;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateExpense(Map<String, BigDecimal> amounts, List<String> decomentCodes) {
        if (CollectionUtils.isEmpty(decomentCodes) && Objects.isNull(amounts)) {
            return;
        }
        List<InvoiceExpenseSheet> expenseSheets = this.invoiceExpenseSheetRepository.findByCodes(decomentCodes);
        if (CollectionUtils.isEmpty(expenseSheets)) {
            return;
        }
        expenseSheets.forEach(aa -> {
            BigDecimal amount = (BigDecimal)amounts.get(aa.getInvoiceExpenseSheetCode());
            aa.setAmount(amount);
        });
        this.invoiceExpenseSheetRepository.saveOrUpdateBatch(expenseSheets);
    }

    public Map<String, String> findCashing(Set<String> documentCodes) {
        if (CollectionUtils.isEmpty(documentCodes)) {
            return null;
        }
        List<InvoiceExpenseSheet> invoiceExpenseSheets = this.invoiceExpenseSheetRepository.findByCodes(Lists.newArrayList(documentCodes));
        if (CollectionUtils.isEmpty(invoiceExpenseSheets)) {
            return null;
        }
        Map<String, String> chshingMap = invoiceExpenseSheets.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getCashingType())).collect(Collectors.toMap(InvoiceExpenseSheet::getInvoiceExpenseSheetCode, InvoiceExpenseSheet::getCashingType));
        return chshingMap;
    }
}

