package com.biz.crm.kms.business.invoice.expense.sheet.sdk.constant;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * 费用单常量类
 *
 * @author ning.zhang
 * @date 2022/11/3
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class ExpenseSheetConstant {

  /**
   * KMS单据验收单 MQ topic
   */
  public static final String KMS_EXPENSE_SHEET_TOPIC = "KMS_EXPENSE_SHEET_TOPIC";

  /**
   * 费用单redis锁定时间
   * */
  public static final Integer EXPENSE_SHEET_REDIS_TIME = 1800;

  /**
   * 费用单自动转换 分页size
   */
  public static final Integer EXPENSE_SHEET_PAGE_SIZE = 800;

  /**
   * 费用单自动转换 分页后最大循环次数  和 上个参数配合使用
   * 自动转换单词最大自动转换数量为   {@link EXPENSE_SHEET_PAGE_SIZE }*{@link EXPENSE_SHEET_LOOP_MAX }
   */
  public static final Integer EXPENSE_SHEET_LOOP_MAX = 1000;

  /**
   * 费用单消息tag
   * */
  public static final String EXPENSE_SHEET_MESSAGE_TAG = "KMS_EXPENSE_SHEET_MESSAGE_TAG";

  /**
   * 费用单未转换单据自动转换redis锁前缀
   * */
  public static final String EXPENSE_SHEET_AUTO_NOT_CONVERT_LOCK = "KMS:EXPENSE_SHEET:AUTO_NOT_CONVERT:LOCK";

  /**
   * 费用单转换失败数据单据自动转换redis锁前缀
   * */
  public static final String EXPENSE_SHEET_AUTO_FAIL_CONVERT_LOCK = "KMS:EXPENSE_SHEET:AUTO_FAIL_CONVERT:LOCK";

  /**
   * 费用单手动转换redis锁前缀
   * */
  public static final String EXPENSE_SHEET_CONVERT_LOCK = "KMS:EXPENSE_SHEET:CONVERT:LOCK";

  /**
   * 费用单转换成功描述
   */
  public static final String EXPENSE_SHEET_CONVERT_SUCCESS_MSG = "转换成功";

  /**
   * 缓存税率的key
   */
  public static final String CACHE_PRODUCT_TAX_RATE = "KMS:CACHE:PRODUCT_TAX_RATE";

}
