package com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Set;

/**
 * @Class InvoiceExpenseSheetDto
 * @Description 单据-费用单请求参数
 * @Author : ZS
 * @Date: 2022/11/12  16:18
 */
@Data
public class InvoiceExpenseSheetDto extends TenantFlagOpDto {

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    private String businessUnitCode;

    /**
     * 系统编码
     */
    @ApiModelProperty("系统编码")
    private String directCode;

    /**
     * 商超名称
     */
    @ApiModelProperty("系统名称")
    private String supermarketName;

    @ApiModelProperty("销售组织编码")
    private String salesOrgCode;

    @ApiModelProperty("销售组织名称")
    private String salesOrgName;


    /**
     * 售达方名称
     */
    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    /**
     * 售达方编码
     */
    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    /**
     * 费用单号
     */
    @ApiModelProperty("费用单号")
    private String invoiceExpenseSheetCode;

    /**
     * 结算单号
     */
    @ApiModelProperty("关联结算单号")
    private String statementCode;

    /**
     * 送达方编码
     */
    @ApiModelProperty("送达方编码")
    private String deliveryPartyCode;

    /**
     * 送达方名称
     */
    @ApiModelProperty("送达方名称")
    private String deliveryPartyName;

    /**
     * 零售商门店编码
     */
    @ApiModelProperty("零售商门店编码")
    private String supermarketStoreCode;

    /**
     * 零售商门店名称
     */
    @ApiModelProperty("零售商门店名称")
    private String supermarketStoreName;

    @ApiModelProperty("零售商区域编码")
    private String areaCode;

    @ApiModelProperty("零售商区域名称")
    private String areaName;

    @ApiModelProperty("业务区域")
    private String businessArea;
    @ApiModelProperty("开始时间")
    private String startTime;
    @ApiModelProperty("结束时间")
    private String endTime;
    /**
     * 单据日期
     */
    @ApiModelProperty("单据日期")
    private String orderDate;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    private String productName;


    /**
     * 零售商产品编码
     */
    @ApiModelProperty("零售商产品编码")
    private String kaProductCode;

    /**
     * 零售商产品名称
     */
    @ApiModelProperty("零售商产品名称")
    private String kaProductName;

    /**
     * 扣费明细项
     */
    @ApiModelProperty("扣费明细项编码")
    private String deductionCode;

    /**
     * 扣费明细项
     */
    @ApiModelProperty("扣费明细项名称")
    private String deductionName;

    /**
     * 扣费金额（含税）
     */
    @ApiModelProperty("扣费金额（含税）")
    private BigDecimal amount;

    /**
     * 扣费金额（不含税）
     */
    @ApiModelProperty("扣费金额（不含税）")
    private BigDecimal amount_not;

    /**
     * 兑付方式
     */
    @ApiModelProperty("兑付方式")
    private String cashingType;

    /**
     * 结案形式
     */
    @ApiModelProperty("结案形式")
    private String auditWay;

    /**
     * 单据来源
     */
    @ApiModelProperty("单据来源")
    private String invoicesSource;

    @ApiModelProperty("转换状态")
    private String orderStatus;

    @ApiModelProperty("转换状态描述")
    private String orderStatusMsg;

    @ApiModelProperty("零售商名称集合")
    private Set<String> kaNamelist;

    @ApiModelProperty("零售商编码集合")
    private Set<String> kaCodelist;

    @ApiModelProperty("业务区域集合")
    private Set<String> businessAreaList;

    @ApiModelProperty("费用明细编码")
    private Set<String> deductionCodeList;

    @ApiModelProperty("费用明细名称")
    private Set<String> deductionNameList;
}
