package com.biz.crm.kms.business.invoice.expense.sheet.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 费用单状态
 */
@Getter
@AllArgsConstructor
public enum ExpenseSheetStatus {

  /**
   * 转换失败
   */
  S100("s100", "100", "转换失败", 0),
  /**
   * 待转换
   */
  S101("s101", "101", "待转换", 1),
  /**
   * 待确认
   */
  S200("s200", "200", "待确认", 2),
  /**
   * 已确认
   */
  S300("s300", "300", "已确认", 3),
  /**
   * 待处理
   */
  S400("s400", "400", "待处理", 4),
  /**
   * 传送SAP成功
   */
  S500("s500", "500", "传送SAP成功", 5),
  /**
   * 传送SAP失败
   */
  S501("s501", "501", "传送SAP失败", 6),
  /**
   * 已匹配
   */
  S600("s600", "600", "已匹配", 7),;

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private Integer order;

  /**
   * 通过字典编码获取枚举值
   *
   * @param dictCode 字典编码
   * @return 取枚举值
   */
  public static ExpenseSheetStatus getByDictCode(String dictCode) {
    ExpenseSheetStatus result = null;
    for (ExpenseSheetStatus type : ExpenseSheetStatus.values()) {
      if (type.getDictCode().equals(dictCode)) {
        result = type;
        break;
      }
    }
    return result;
  }
}
