package com.biz.crm.kms.business.invoice.expense.sheet.sdk.event;

import com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

public interface InvoiceExpenseSheetLogEventListener extends NebulaEvent {
    /**
     * 创建预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onCreate(InvoiceExpenseSheetLogEventDto dto);

    /**
     * 删除预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onDelete(InvoiceExpenseSheetLogEventDto dto);

    /**
     * 修改预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onUpdate(InvoiceExpenseSheetLogEventDto dto);

    /**
     * 启用预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onEnable(InvoiceExpenseSheetLogEventDto dto);

    /**
     * 禁用预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onDisable(InvoiceExpenseSheetLogEventDto dto);
    
    
}
