package com.biz.crm.kms.business.invoice.expense.sheet.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 *
 */
public interface InvoiceExpenseSheetVoService {
    /**
     * 根据条件查询费用单数据
     * @param invoiceExpenseSheetDto
     * @return
     */
    List<InvoiceExpenseSheetDto> findExpenseSheet(InvoiceExpenseSheetDto invoiceExpenseSheetDto);

    /**
     * 分页查询费用单
     * @param pageable
     * @param dto
     * @return
     */
    Page<InvoiceExpenseSheetDto> findExpenseSheetPaging(Pageable pageable, InvoiceExpenseSheetDto dto);

    /**
     * 手动转换
     * @param ids
     * @return
     */
    void manualSwitch(List<String> ids);

    /**
     * 关联结算单
     * @param orderNumbers
     * @param statementCode
     */
    void match(List<String> orderNumbers,String statementCode);

    /**
     * 通过高鑫系统编码和含税金额为空
     * @param directCodes
     * @return
     */
    List<String> syncExpense(List<String> directCodes);

    /**
     * 同步金额并保存
     * @param amounts
     * @param decomentCodes
     */
    void updateExpense(Map<String , BigDecimal> amounts, List<String> decomentCodes);

    /**
     * 查找兑付方式
     * @param documentCodes
     * @return
     */
    Map<String ,String> findCashing(Set<String> documentCodes);
}
