package com.biz.crm.kms.business.invoice.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.invoice.sdk.constant.InvoiceConstant;
import com.biz.crm.kms.business.invoice.sdk.service.InvoiceTypeService;
import com.biz.crm.kms.business.invoice.sdk.vo.InvoiceTypeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 单据基座控制层
 *
 * @author songjingen
 * @date 2022/9/28
 */
@RequestMapping("/v1/invoice/invoiceType")
@RestController
@Api(tags = "单据基座：InvoiceType：单据类型")
@Slf4j
public class InvoiceTypeController {

  @Autowired
  private InvoiceTypeService invoiceTypeService;

  /**
   * 查询所有单据类型
   *
   * @return 单条数据
   */
  @ApiOperation(value = "查询所有单据类型")
  @GetMapping("findAll")
  public Result<List<InvoiceTypeVo>> findAll() {
    try {
      List<InvoiceTypeVo> invoiceTypes = this.invoiceTypeService.findAll();
      return Result.ok(invoiceTypes);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 条件查询单据类型
   *
   * @return 单条数据
   */
  @ApiOperation(value = "条件查询单据类型")
  @GetMapping("findByCondition")
  public Result<List<InvoiceTypeVo>> findByCondition(@RequestParam("type")String type) {
    try {
      List<InvoiceTypeVo> invoiceTypes = this.invoiceTypeService.findByCondition(type);
      return Result.ok(invoiceTypes);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查询所有单据类型（包含登录）
   *
   * @return 单条数据
   */
  @ApiOperation(value = "查询所有单据类型（包含登录）")
  @GetMapping("findAllIncludeLogin")
  public Result<List<InvoiceTypeVo>> findAllIncludeLogin() {
    try {
      InvoiceTypeVo typeVo = new InvoiceTypeVo();
      typeVo.setType(InvoiceConstant.LOGIN_ORDER_TYPE);
      typeVo.setName(InvoiceConstant.LOGIN_ORDER_NAME);
      List<InvoiceTypeVo> allInvoiceTypes = new ArrayList<>();
      allInvoiceTypes.add(typeVo);
      List<InvoiceTypeVo> invoiceTypes = this.invoiceTypeService.findAll();
      allInvoiceTypes.addAll(invoiceTypes);
      return Result.ok(allInvoiceTypes);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
