package com.biz.crm.kms.business.invoice.local.service.internal;


import com.biz.crm.kms.business.invoice.sdk.service.InvoiceStatisticsVoService;
import com.biz.crm.kms.business.invoice.sdk.strategy.InvoiceStatisticsStrategy;
import com.biz.crm.kms.business.invoice.sdk.vo.InvoiceStatisticsVo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * 单据统计接口实现类
 *
 * @author songjingen
 * @date 2022/11/2 17:47
 */
@Service
public class InvoiceStatisticsVoServiceImpl implements InvoiceStatisticsVoService {

  @Autowired(required = false)
  private List<InvoiceStatisticsStrategy> invoiceStatisticsStrategies;


  @Override
  public List<InvoiceStatisticsVo> findByType(String type, List<Date> invoiceDates, List<String> goodsCodes, List<String> storeCodes, List<String> kaOrderNumbers, List... args) {
    if (CollectionUtils.isEmpty(this.invoiceStatisticsStrategies) || StringUtils.isBlank(type)) {
      return null;
    }
    for (InvoiceStatisticsStrategy invoiceStatisticsStrategy : this.invoiceStatisticsStrategies) {
      if (invoiceStatisticsStrategy.getType().equals(type)) {
        return invoiceStatisticsStrategy.findInvoiceStatistics(invoiceDates, goodsCodes, storeCodes, kaOrderNumbers, args);
      }
    }
    return null;
  }

  @Override
  public List<InvoiceStatisticsVo> findByConditions(String type, List<String> goodsCodes, List<String> storeCodes, List<String> orderCodes, String beginDate,String endDate, List<String> soldToPartyCodes, List<String> directCodes) {
    if (CollectionUtils.isEmpty(this.invoiceStatisticsStrategies) || StringUtils.isBlank(type)) {
      return null;
    }
    for (InvoiceStatisticsStrategy invoiceStatisticsStrategy : this.invoiceStatisticsStrategies) {
      if (invoiceStatisticsStrategy.getType().equals(type)) {
        return invoiceStatisticsStrategy.findByConditions(type, goodsCodes, storeCodes, orderCodes, beginDate, endDate, soldToPartyCodes, directCodes);
      }
    }
    return null;
  }

  @Override
  public List<InvoiceStatisticsVo> findByRelationId(String type, List<String> relationId) {
    if (CollectionUtils.isEmpty(this.invoiceStatisticsStrategies) || StringUtils.isBlank(type)) {
      return null;
    }
    for (InvoiceStatisticsStrategy invoiceStatisticsStrategy : this.invoiceStatisticsStrategies) {
      if (invoiceStatisticsStrategy.getType().equals(type)) {
        return invoiceStatisticsStrategy.findByRelationId(relationId);
      }
    }
    return null;
  }

  @Override
  public List<InvoiceStatisticsVo> findCrossByConditions(String type, List<String> relationKaOrderCodes, List<String> acceptanceOrderNumber) {
    if (CollectionUtils.isEmpty(this.invoiceStatisticsStrategies) || StringUtils.isBlank(type)) {
      return null;
    }
    for (InvoiceStatisticsStrategy invoiceStatisticsStrategy : this.invoiceStatisticsStrategies) {
      if (invoiceStatisticsStrategy.getType().equals(type)) {
        return invoiceStatisticsStrategy.findCrossByConditions(relationKaOrderCodes, acceptanceOrderNumber);
      }
    }
    return null;
  }

}
