package com.biz.crm.kms.business.invoice.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.kms.business.invoice.sdk.register.InvoiceTypeRegister;
import com.biz.crm.kms.business.invoice.sdk.service.InvoiceTypeService;
import com.biz.crm.kms.business.invoice.sdk.vo.InvoiceTypeVo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * 单据类型service实现类
 *
 * @author songjingen
 * @date 2022/9/28
 */
@Service
public class InvoiceTypeServiceImpl implements InvoiceTypeService {

  @Autowired(required = false)
  private List<InvoiceTypeRegister> invoiceTypeRegisters;

  @Override
  public List<InvoiceTypeVo> findAll() {
    if (CollectionUtils.isEmpty(this.invoiceTypeRegisters)) {
      return new ArrayList<>(0);
    }
    List<InvoiceTypeRegister> invoiceTypeRegistersSortedOrder = this.invoiceTypeRegisters.stream()
        .sorted(Comparator.comparing(InvoiceTypeRegister::order))
        .collect(Collectors.toList());
    List<InvoiceTypeVo> invoiceTypeVos = new ArrayList<>();
    for (InvoiceTypeRegister invoiceTypeRegister : invoiceTypeRegistersSortedOrder) {
      InvoiceTypeVo invoiceTypeVo = new InvoiceTypeVo();
      invoiceTypeVo.setType(invoiceTypeRegister.type());
      invoiceTypeVo.setName(invoiceTypeRegister.name());
      invoiceTypeVos.add(invoiceTypeVo);
    }
    return invoiceTypeVos;
  }

  @Override
  public List<InvoiceTypeVo> findByCondition(String type) {
    List<InvoiceTypeVo> invoiceTypeVos = new ArrayList<>();
    if (StringUtils.isNotEmpty(type)){
      if (CollectionUtils.isEmpty(this.invoiceTypeRegisters)) {
        return new ArrayList<>(0);
      }
      List<InvoiceTypeRegister> invoiceTypeRegistersSortedOrder = this.invoiceTypeRegisters.stream()
              .sorted(Comparator.comparing(InvoiceTypeRegister::order))
              .collect(Collectors.toList());
      for (InvoiceTypeRegister invoiceTypeRegister : invoiceTypeRegistersSortedOrder) {
        InvoiceTypeVo invoiceTypeVo = new InvoiceTypeVo();
        if (StringUtils.equals(invoiceTypeRegister.type(),type)){
          invoiceTypeVo.setType(invoiceTypeRegister.type());
          invoiceTypeVo.setName(invoiceTypeRegister.name());
          invoiceTypeVos.add(invoiceTypeVo);
        }
      }
      return invoiceTypeVos;
    }else {
      return invoiceTypeVos;
    }
  }
}
