package com.biz.crm.kms.business.invoice.order.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 订单商品抓取数据(python)类
 *
 * @author ning.zhang
 * @date 2022/10/12
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "OrderGoodsGrabEntity", description = "订单商品抓取数据(python)类")
@Entity
@TableName("kms_order_goods_grab")
@Table(name = "kms_order_goods_grab", indexes = {
    @Index(name = "kms_order_goods_grab_index1", columnList = "tenant_code"),
    @Index(name = "kms_order_goods_grab_index2", columnList = "raw_data_id"),
    @Index(name = "kms_order_goods_grab_index3", columnList = "direct_code"),
    @Index(name = "kms_order_goods_grab_index4", columnList = "order_number"),
    @Index(name = "kms_order_goods_grab_index5", columnList = "ka_order_number"),
    @Index(name = "kms_order_goods_grab_index6", columnList = "goods_code"),
    @Index(name = "kms_order_goods_grab_index7", columnList = "ka_goods_code"),
    @Index(name = "kms_order_goods_grab_index8", columnList = "version_number"),
})
@org.hibernate.annotations.Table(appliesTo = "kms_order_goods_grab", comment = "订单商品抓取数据(python)表")
public class OrderGoodsGrabEntity extends TenantOpEntity {

  private static final long serialVersionUID = 6734772177425374455L;

  /**
   * 原始数据ID
   */
  @ApiModelProperty("原始数据ID")
  @Column(name = "raw_data_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '原始数据ID 对应表 kms_grab_response_data 的ID'")
  private String rawDataId;

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  @Column(name = "direct_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '系统编码'")
  private String directCode;

  /**
   * 抓单生成的订单编号
   */
  @ApiModelProperty("抓单生成的订单编号")
  @Column(name = "order_number", length = 64, columnDefinition = "VARCHAR(64) COMMENT '抓单生成的订单编号'")
  private String orderNumber;

  /**
   * 订单版本号
   */
  @ApiModelProperty("订单版本号")
  @Column(name = "version_number", length = 10, columnDefinition = "INT(10) COMMENT '订单版本号'")
  private Integer versionNumber;

  /**
   * 商超订单编号
   */
  @ApiModelProperty("商超订单编号")
  @Column(name = "ka_order_number", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商超订单编号'")
  private String kaOrderNumber;

  /**
   * 商超名称
   */
  @ApiModelProperty("商超名称")
  @Column(name = "ka_name", columnDefinition = "VARCHAR(255) COMMENT '商超名称'")
  private String kaName;

  /**
   * 企业产品编号
   */
  @ApiModelProperty("企业产品编号")
  @Column(name = "goods_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '企业产品编号'")
  private String goodsCode;

  /**
   * 企业产品名称
   */
  @ApiModelProperty("企业产品名称")
  @Column(name = "goods_name", columnDefinition = "VARCHAR(255) COMMENT '企业产品名称'")
  private String goodsName;

  /**
   * 商超产品编号
   */
  @ApiModelProperty("商超产品编号")
  @Column(name = "ka_goods_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商超产品编号'")
  private String kaGoodsCode;

  /**
   * 商超产品名称
   */
  @ApiModelProperty("商超产品名称")
  @Column(name = "ka_goods_name", columnDefinition = "VARCHAR(255) COMMENT '商超产品名称'")
  private String kaGoodsName;

  /**
   * 产品国际条码
   */
  @ApiModelProperty("产品国际条码")
  @Column(name = "goods_bar_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '产品国际条码'")
  private String goodsBarCode;

  /**
   * 产品规格
   */
  @ApiModelProperty("产品规格")
  @Column(name = "specification", length = 64, columnDefinition = "VARCHAR(64) COMMENT '产品规格'")
  private String specification;

  /**
   * 订货单价（含税）
   */
  @ApiModelProperty("订货单价（含税）")
  @Column(name = "unit_price", columnDefinition = "DECIMAL(20,4) COMMENT '订货单价（含税）'")
  private BigDecimal unitPrice;

  /**
   * 订货金额小计（含税）
   */
  @ApiModelProperty("订货金额小计（含税）")
  @Column(name = "order_amount", columnDefinition = "DECIMAL(20,4) COMMENT '订货金额小计（含税）'")
  private BigDecimal orderAmount;

  /**
   * 订货单价（不含税）
   */
  @ApiModelProperty("订货单价（不含税）")
  @Column(name = "unit_price_not", columnDefinition = "DECIMAL(20,4) COMMENT '订货单价（不含税）'")
  private BigDecimal unitPriceNot;

  /**
   * 订货金额小计（不含税）
   */
  @ApiModelProperty("订货金额小计（不含税）")
  @Column(name = "order_amount_not", columnDefinition = "DECIMAL(20,4) COMMENT '订货金额小计（不含税）'")
  private BigDecimal orderAmountNot;

  /**
   * 当前单位层级
   */
  @ApiModelProperty("当前单位层级")
  @Column(name = "cur_unit_level", length = 64, columnDefinition = "VARCHAR(64) COMMENT '当前单位层级'")
  private String curUnitLevel;

  /**
   * 商超当前单位
   */
  @ApiModelProperty("商超当前单位")
  @Column(name = "cur_unit", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商超当前单位'")
  private String curUnit;

  /**
   * 商超当前单位订货数量
   */
  @ApiModelProperty("商超当前单位订货数量")
  @Column(name = "cur_unit_order_quantity", columnDefinition = "DECIMAL(20,4) COMMENT '商超当前单位订货数量'")
  private BigDecimal curUnitOrderQuantity;

  /**
   * 最小单位层级
   */
  @ApiModelProperty("最小单位层级")
  @Column(name = "min_unit_level", length = 64, columnDefinition = "VARCHAR(64) COMMENT '最小单位层级'")
  private String minUnitLevel;

  /**
   * 最小单位
   */
  @ApiModelProperty("最小单位")
  @Column(name = "min_unit", length = 64, columnDefinition = "VARCHAR(64) COMMENT '最小单位'")
  private String minUnit;

  /**
   * 最小单位订货数量
   */
  @ApiModelProperty("最小单位订货数量")
  @Column(name = "min_unit_order_quantity", columnDefinition = "DECIMAL(20,4) COMMENT '最小单位订货数量'")
  private BigDecimal minUnitOrderQuantity;

  /**
   * 最大单位层级
   */
  @ApiModelProperty("最大单位层级")
  @Column(name = "max_unit_level", length = 64, columnDefinition = "VARCHAR(64) COMMENT '最大单位层级'")
  private String maxUnitLevel;

  /**
   * 最小单位
   */
  @ApiModelProperty("最大单位")
  @Column(name = "max_unit", length = 64, columnDefinition = "VARCHAR(64) COMMENT '最大单位'")
  private String maxUnit;

  /**
   * 最大单位订货数量
   */
  @ApiModelProperty("最大单位订货数量")
  @Column(name = "max_unit_order_quantity", columnDefinition = "DECIMAL(20,4) COMMENT '最大单位订货数量'")
  private BigDecimal maxUnitOrderQuantity;

  /**
   * 工厂编码
   */
  @ApiModelProperty("工厂编码")
  @Column(name = "factory_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '工厂编码'")
  private String factoryCode;

  /**
   * 工厂名称
   */
  @ApiModelProperty("工厂名称")
  @Column(name = "factory_name", columnDefinition = "VARCHAR(255) COMMENT '工厂名称'")
  private String factoryName;

  /**
   * 产品税率
   */
  @ApiModelProperty("产品税率")
  @Column(name = "pro_rate", length = 64, columnDefinition = "VARCHAR(64) COMMENT '产品税率'")
  private String proRate;

  /**
   * 折扣
   */
  @ApiModelProperty("折扣")
  @Column(name = "pro_rebate", length = 64, columnDefinition = "VARCHAR(64) COMMENT '折扣'")
  private String proRebate;

  /**
   * 详情来源
   */
  @ApiModelProperty("详情来源")
  @Column(name = "data_from", length = 64, columnDefinition = "VARCHAR(64) COMMENT '详情来源'")
  private String dataFrom;

  /**
   * 维护单价
   */
  @ApiModelProperty("维护单价")
  @Column(name = "order_price", columnDefinition = "DECIMAL(20,4) COMMENT '维护单价'")
  private BigDecimal orderPrice;

  /**
   * 单价差异
   */
  @ApiModelProperty("单价差异")
  @Column(name = "price_diff", columnDefinition = "DECIMAL(20,4) COMMENT '单价差异'")
  private BigDecimal priceDiff;

  /**
   * 行信息排序
   */
  @ApiModelProperty("行信息排序")
  @Column(name = "item_index", columnDefinition = "INT(11) COMMENT '行信息排序'")
  private Integer itemIndex;
}