package com.biz.crm.kms.business.invoice.order.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.List;

/**
 * 订单抓取数据(python)类
 *
 * @author ning.zhang
 * @date 2022/10/10
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "OrderGrabEntity", description = "订货单抓取数据(python)类")
@Entity
@TableName("kms_order_grab")
@Table(name = "kms_order_grab", indexes = {
    @Index(name = "kms_order_grab_index1", columnList = "tenant_code"),
    @Index(name = "kms_order_grab_index2", columnList = "raw_data_id"),
    @Index(name = "kms_order_grab_index3", columnList = "direct_code"),
    @Index(name = "kms_order_grab_index4", columnList = "order_number"),
    @Index(name = "kms_order_grab_index5", columnList = "ka_order_number"),
    @Index(name = "kms_order_grab_index6", columnList = "version_number"),
})
@org.hibernate.annotations.Table(appliesTo = "kms_order_grab", comment = "订货单抓取数据(python)表")
public class OrderGrabEntity extends TenantOpEntity {

  private static final long serialVersionUID = 2482359986427998428L;

  /**
   * 原始数据ID
   */
  @ApiModelProperty("原始数据ID")
  @Column(name = "raw_data_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '原始数据ID 对应表 kms_grab_response_data 的ID'")
  private String rawDataId;

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  @Column(name = "direct_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '系统编码'")
  private String directCode;

  /**
   * 抓单生成的订单编号
   */
  @ApiModelProperty("抓单生成的订单编号")
  @Column(name = "order_number", length = 64, columnDefinition = "VARCHAR(64) COMMENT '抓单生成的订单编号'")
  private String orderNumber;

  /**
   * 订单版本号
   */
  @ApiModelProperty("订单版本号")
  @Column(name = "version_number", length = 10, columnDefinition = "INT(10) COMMENT '订单版本号'")
  private Integer versionNumber;

  /**
   * 商超订单编号
   */
  @ApiModelProperty("商超订单编号")
  @Column(name = "ka_order_number", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商超订单编号'")
  private String kaOrderNumber;

  /**
   * 单据来源
   */
  @ApiModelProperty("单据来源")
  @Column(name = "invoices_source", length = 64, columnDefinition = "VARCHAR(64) COMMENT '单据来源'")
  private String invoicesSource;

  /**
   * 商超编码
   */
  @ApiModelProperty("商超编码")
  @Column(name = "ka_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商超编码'")
  private String kaCode;

  /**
   * 商超名称
   */
  @ApiModelProperty("商超名称")
  @Column(name = "ka_name", columnDefinition = "VARCHAR(255) COMMENT '商超名称'")
  private String kaName;

  /**
   * 订单日期
   */
  @ApiModelProperty("订单日期")
  @Column(name = "order_date", length = 64, columnDefinition = "VARCHAR(64) COMMENT '订单日期'")
  private String orderDate;

  /**
   * 交货日期
   */
  @ApiModelProperty("交货日期")
  @Column(name = "delivery_date", length = 64, columnDefinition = "VARCHAR(64) COMMENT '交货日期'")
  private String deliveryDate;

  /**
   * 经营方式
   */
  @ApiModelProperty("经营方式")
  @Column(name = "run_mode", length = 64, columnDefinition = "VARCHAR(64) COMMENT '经营方式'")
  private String runMode;

  /**
   * 订货单总金额（含税）
   */
  @ApiModelProperty("订货单总金额（含税）")
  @Column(name = "final_order_amount", columnDefinition = "DECIMAL(20,4) COMMENT '订货单总金额（含税）'")
  private BigDecimal finalOrderAmount;

  /**
   * 订货单总金额（不含税）
   */
  @ApiModelProperty("订货单总金额（不含税）")
  @Column(name = "final_order_amount_not", columnDefinition = "DECIMAL(20,4) COMMENT '订货单总金额（不含税）'")
  private BigDecimal finalOrderAmountNot;

  /**
   * 商超门店/大仓编号
   */
  @ApiModelProperty("商超门店/大仓编号")
  @Column(name = "ka_store_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商超门店/大仓编号'")
  private String kaStoreCode;

  /**
   * 商超门店/大仓名称
   */
  @ApiModelProperty("商超门店/大仓名称")
  @Column(name = "ka_store_name", columnDefinition = "VARCHAR(255) COMMENT '商超门店/大仓名称'")
  private String kaStoreName;

  /**
   * 企业门店/大仓编号
   */
  @ApiModelProperty("企业门店/大仓编号")
  @Column(name = "store_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '企业门店/大仓编号'")
  private String storeCode;

  /**
   * 企业门店/大仓名称
   */
  @ApiModelProperty("企业门店/大仓名称")
  @Column(name = "store_name", columnDefinition = "VARCHAR(255) COMMENT '企业门店/大仓名称'")
  private String storeName;

  /**
   * 送货地址
   */
  @ApiModelProperty("送货地址")
  @Column(name = "delivery_address", columnDefinition = "VARCHAR(255) COMMENT '送货地址'")
  private String deliveryAddress;

  /**
   * 送货联系人
   */
  @ApiModelProperty("送货联系人")
  @Column(name = "delivery_contact", length = 64, columnDefinition = "VARCHAR(64) COMMENT '送货联系人'")
  private String deliveryContact;

  /**
   * 送货联系人电话
   */
  @ApiModelProperty("送货联系人电话")
  @Column(name = "delivery_contact_phone", length = 64, columnDefinition = "VARCHAR(64) COMMENT '送货联系人电话'")
  private String deliveryContactPhone;

  /**
   * 业务区域负责人
   */
  @ApiModelProperty("业务区域负责人")
  @Column(name = "business_area_leader", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务区域负责人'")
  private String businessAreaLeader;

  /**
   * 业务区域
   */
  @ApiModelProperty("业务区域")
  @Column(name = "business_area", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务区域'")
  private String businessArea;

  /**
   * 区域编码
   */
  @ApiModelProperty("区域编码")
  @Column(name = "area_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '区域编码'")
  private String areaCode;

  /**
   * 区域名称
   */
  @ApiModelProperty("区域名称")
  @Column(name = "area_name", columnDefinition = "VARCHAR(255) COMMENT '区域名称'")
  private String areaName;

  /**
   * 订单审批单号
   */
  @ApiModelProperty("订单审批单号")
  @Column(name = "order_approval_number", length = 64, columnDefinition = "VARCHAR(64) COMMENT '订单审批单号'")
  private String orderApprovalNumber;

  /**
   * 登录账号
   */
  @ApiModelProperty("登录账号")
  @Column(name = "user_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '登录账号'")
  private String userName;

  /**
   * 转换状态
   *
   * @see com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus
   */
  @ApiModelProperty("转换状态")
  @Column(name = "trans_status", length = 32, columnDefinition = "VARCHAR(32) DEFAULT '0' NOT NULL COMMENT '转换状态'")
  private String transStatus;

  /**
   * SKU最大单位数量汇总
   */
  @ApiModelProperty("SKU最大单位数量汇总")
  @Column(name = "max_unit_sum", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'SKU最大单位数量汇总'")
  private String maxUnitSum;

  /**
   * 订货单商品列表
   */
  @ApiModelProperty("订货单商品列表")
  @TableField(exist = false)
  @Transient
  private List<OrderGoodsGrabEntity> goodsList;
}