package com.biz.crm.kms.business.invoice.order.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 订货单状态流转记录类
 *
 * @author ning.zhang
 * @date 2022/10/12
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "OrderStatusRecordEntity", description = "订货单状态流转记录类")
@Entity
@TableName("kms_order_status_record")
@Table(name = "kms_order_status_record", indexes = {
    @Index(name = "kms_order_status_record_index1", columnList = "tenant_code"),
    @Index(name = "kms_order_status_record_index2", columnList = "order_number"),
    @Index(name = "kms_order_status_record_index3", columnList = "ka_order_number"),
})
@org.hibernate.annotations.Table(appliesTo = "kms_order_status_record", comment = "订货单状态流转记录表")
public class OrderStatusRecordEntity extends TenantOpEntity {

  private static final long serialVersionUID = 6322662148756572638L;

  /**
   * 抓单生成的订单编号
   */
  @ApiModelProperty("抓单生成的订单编号")
  @Column(name = "order_number", length = 64, columnDefinition = "VARCHAR(64) COMMENT '抓单生成的订单编号'")
  private String orderNumber;

  /**
   * 订单版本号
   */
  @ApiModelProperty("订单版本号")
  @Column(name = "version_number", length = 10, columnDefinition = "INT(10) COMMENT '订单版本号'")
  private Integer versionNumber;

  /**
   * 商超订单编号
   */
  @ApiModelProperty("商超订单编号")
  @Column(name = "ka_order_number", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商超订单编号'")
  private String kaOrderNumber;

  /**
   * 订单当前状态
   *
   * @see com.biz.crm.kms.business.invoice.order.sdk.enums.OrderStatus
   */
  @ApiModelProperty("订单当前状态")
  @Column(name = "order_status", length = 32, columnDefinition = "VARCHAR(32) COMMENT '订单当前状态'")
  private String orderStatus;

  /**
   * 单据当前状态信息
   */
  @ApiModelProperty("单据当前状态信息")
  @Column(name = "order_status_msg", columnDefinition = "VARCHAR(255) COMMENT '单据当前状态信息'")
  private String orderStatusMsg;
}