package com.biz.crm.kms.business.invoice.order.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.kms.business.invoice.order.local.entity.OrderGrabEntity;
import com.biz.crm.kms.business.invoice.order.local.model.OrderGrabConditionModel;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 订货单抓取数据(python)表的mybatis-plus接口类 {@link OrderGrabEntity}
 *
 * @author ning.zhang
 * @date 2022-10-12 16:37:52
 */
public interface OrderGrabMapper extends BaseMapper<OrderGrabEntity> {

  /**
   * 多条件查询订货单抓取数据列表
   *
   * @param model 条件model
   * @return 订货单抓取数据列表
   */
  List<OrderGrabEntity> findByOrderGrabConditionModel(@Param("model") OrderGrabConditionModel model);
}

