package com.biz.crm.kms.business.invoice.order.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.invoice.order.local.entity.OrderEntity;
import com.biz.crm.kms.business.invoice.order.local.model.OrderConditionModel;
import com.biz.crm.kms.business.invoice.order.sdk.dto.OrderPageDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 订货单表的mybatis-plus接口类 {@link OrderEntity}
 *
 * @author ning.zhang
 * @date 2022-10-12 16:37:32
 */
public interface OrderMapper extends BaseMapper<OrderEntity> {

  /**
   * 多条件查询订货单规则列表
   *
   * @param model 条件model
   * @return 订货单规则列表
   */
  List<OrderEntity> findByOrderConditionModel(@Param("model") OrderConditionModel model);

  /**
   * 订货单分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<OrderEntity> 订货单分页信息
   */
  Page<OrderEntity> findByConditions(Page<OrderEntity> page, @Param("dto") OrderPageDto dto);
}

