package com.biz.crm.kms.business.invoice.order.local.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 订货单抓取数据多条件model
 *
 * @author ning.zhang
 * @date 2022/10/12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "OrderGrabConditionModel", description = "订货单抓取数据多条件model")
public class OrderGrabConditionModel {

  /**
   * 租户编号
   */
  @ApiModelProperty("租户编号")
  private String tenantCode;

  /**
   * 转换状态
   *
   * @see com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus
   */
  @ApiModelProperty("转换状态")
  private String transStatus;

}
