package com.biz.crm.kms.business.invoice.order.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.kms.business.invoice.order.local.entity.OrderGoodsEntity;
import com.biz.crm.kms.business.invoice.order.local.mapper.OrderGoodsMapper;
import org.springframework.stereotype.Component;

/**
 * 订货单商品表的数据库访问类 {@link OrderGoodsEntity}
 *
 * @author ning.zhang
 * @date 2022-10-12 16:37:42
 */
@Component
public class OrderGoodsRepository extends ServiceImpl<OrderGoodsMapper, OrderGoodsEntity> {

  /**
   * 根据订货单编码删除数据
   *
   * @param tenantCode 租户编码
   * @param orderNumber 订货单编码
   */
  public void deleteByOrderNumber(String tenantCode, String orderNumber) {
    this.lambdaUpdate()
        .eq(OrderGoodsEntity::getTenantCode, tenantCode)
        .eq(OrderGoodsEntity::getOrderNumber, orderNumber)
        .remove();
  }
}
