package com.biz.crm.kms.business.invoice.order.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.kms.business.invoice.order.local.entity.OrderGrabEntity;
import com.biz.crm.kms.business.invoice.order.local.mapper.OrderGrabMapper;
import com.biz.crm.kms.business.invoice.order.local.model.OrderGrabConditionModel;
import com.biz.crm.kms.business.invoice.sdk.enums.GrabTransStatus;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 订货单抓取数据(python)表的数据库访问类 {@link OrderGrabEntity}
 *
 * @author ning.zhang
 * @date 2022-10-12 16:37:53
 */
@Component
public class OrderGrabRepository extends ServiceImpl<OrderGrabMapper, OrderGrabEntity> {

  /**
   * 多条件查询订货单抓取数据列表
   *
   * @param model 条件model
   * @return 订货单抓取数据列表
   */
  public List<OrderGrabEntity> findByOrderGrabConditionModel(OrderGrabConditionModel model) {
    return this.baseMapper.findByOrderGrabConditionModel(model);
  }

  /**
   * 根据订货单号更新转换状态
   *
   * @param tenantCode  租户编码
   * @param transStatus 转换状态
   * @param orderNumber 订货单号
   */
  public void updateTransStatusByOrderNumber(String tenantCode, GrabTransStatus transStatus, String orderNumber) {
    this.lambdaUpdate()
        .eq(OrderGrabEntity::getTenantCode, tenantCode)
        .eq(OrderGrabEntity::getOrderNumber, orderNumber)
        .set(OrderGrabEntity::getTransStatus, transStatus.getDictCode())
        .update();
  }
}
